/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.reflect.Method;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.data.gemfire.function.DefaultFunctionArgumentResolver;
import org.springframework.util.ClassUtils;

class PdxFunctionArgumentResolver
extends DefaultFunctionArgumentResolver {
    PdxFunctionArgumentResolver() {
    }

    @Override
    public Object[] resolveFunctionArguments(FunctionContext functionContext) {
        Object[] functionArguments = super.resolveFunctionArguments(functionContext);
        if (this.isPdxSerializerConfigured()) {
            int index = 0;
            for (Object functionArgument : functionArguments) {
                String className;
                if (functionArgument instanceof PdxInstance && this.isDeserializationNecessary(className = ((PdxInstance)functionArgument).getClassName())) {
                    functionArguments[index] = ((PdxInstance)functionArgument).getObject();
                }
                ++index;
            }
        }
        return functionArguments;
    }

    @Override
    public Method getFunctionAnnotatedMethod() {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    boolean isPdxSerializerConfigured() {
        try {
            return CacheFactory.getAnyInstance().getPdxSerializer() != null;
        }
        catch (CacheClosedException ignore) {
            return false;
        }
    }

    boolean isDeserializationNecessary(String className) {
        return this.isOnClasspath(className) && this.functionAnnotatedMethodHasParameterOfType(className);
    }

    boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    boolean functionAnnotatedMethodHasParameterOfType(String className) {
        for (Class<?> parameterType : this.getFunctionAnnotatedMethod().getParameterTypes()) {
            if (!parameterType.getName().equals(className)) continue;
            return true;
        }
        return false;
    }
}

