/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.GemfireRepository;
import org.springframework.data.gemfire.repository.Wrapper;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class SimpleGemfireRepository<T, ID>
implements GemfireRepository<T, ID> {
    private final EntityInformation<T, ID> entityInformation;
    private final GemfireTemplate template;

    public SimpleGemfireRepository(GemfireTemplate template, EntityInformation<T, ID> entityInformation) {
        Assert.notNull((Object)template, (String)"Template must not be null");
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null");
        this.template = template;
        this.entityInformation = entityInformation;
    }

    public <U extends T> U save(U entity) {
        Object id = this.entityInformation.getRequiredId(entity);
        this.template.put(id, entity);
        return entity;
    }

    public <U extends T> Iterable<U> saveAll(Iterable<U> entities) {
        HashMap entitiesToSave = new HashMap();
        entities.forEach(entity -> entitiesToSave.put(this.entityInformation.getRequiredId(entity), entity));
        this.template.putAll(entitiesToSave);
        return entitiesToSave.values();
    }

    @Override
    public T save(Wrapper<T, ID> wrapper) {
        T entity = wrapper.getEntity();
        this.template.put(wrapper.getKey(), entity);
        return entity;
    }

    public long count() {
        SelectResults results = this.template.find(String.format("SELECT count(*) FROM %s", this.template.getRegion().getFullPath()), new Object[0]);
        return ((Integer)results.iterator().next()).intValue();
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.template.get(id));
    }

    public Collection<T> findAll() {
        SelectResults results = this.template.find(String.format("SELECT * FROM %s", this.template.getRegion().getFullPath()), new Object[0]);
        return results.asList();
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        QueryString query = QueryString.of("SELECT * FROM /RegionPlaceholder").fromRegion(this.entityInformation.getJavaType(), this.template.getRegion()).orderBy(sort);
        SelectResults selectResults = this.template.find(query.toString(), new Object[0]);
        return selectResults.asList();
    }

    public Collection<T> findAllById(Iterable<ID> ids) {
        List keys = (List)Streamable.of(ids).stream().collect(StreamUtils.toUnmodifiableList());
        return CollectionUtils.nullSafeMap(this.template.getAll(keys)).values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void deleteById(ID id) {
        this.template.remove(id);
    }

    public void delete(T entity) {
        this.deleteById(this.entityInformation.getRequiredId(entity));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(this::delete);
    }

    boolean isPartitioned(Region<?, ?> region) {
        return region != null && region.getAttributes() != null && this.isPartitioned(region.getAttributes().getDataPolicy());
    }

    boolean isPartitioned(DataPolicy dataPolicy) {
        return dataPolicy != null && dataPolicy.withPartitioning();
    }

    boolean isTransactionPresent(Region<?, ?> region) {
        return region.getRegionService() instanceof Cache && this.isTransactionPresent(((Cache)region.getRegionService()).getCacheTransactionManager());
    }

    boolean isTransactionPresent(CacheTransactionManager cacheTransactionManager) {
        return cacheTransactionManager != null && cacheTransactionManager.exists();
    }

    <K> void doRegionClear(Region<K, ?> region) {
        region.removeAll((Collection)region.keySet());
    }

    public void deleteAll() {
        this.template.execute(region -> {
            if (this.isPartitioned(region) || this.isTransactionPresent(region)) {
                this.doRegionClear(region);
            } else {
                try {
                    region.clear();
                }
                catch (UnsupportedOperationException ignore) {
                    this.doRegionClear(region);
                }
            }
            return null;
        });
    }
}

