/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.lang.reflect.Method;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.gemfire.function.execution.DefaultFunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.FunctionExecutionMethodMetadata;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;
import org.springframework.data.gemfire.function.execution.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GemfireFunctionProxyFactoryBean
implements BeanClassLoaderAware,
FactoryBean<Object>,
MethodInterceptor {
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile boolean initialized;
    private final Class<?> functionExecutionInterface;
    private volatile Object functionExecutionProxy;
    private final GemfireFunctionOperations gemfireFunctionOperations;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private FunctionExecutionMethodMetadata<MethodMetadata> methodMetadata;

    public GemfireFunctionProxyFactoryBean(Class<?> functionExecutionInterface, GemfireFunctionOperations gemfireFunctionOperations) {
        Assert.notNull(functionExecutionInterface, (String)"Function execution interface must not be null");
        Assert.isTrue((boolean)functionExecutionInterface.isInterface(), (String)String.format("Function execution type [%s] must be an interface", functionExecutionInterface.getClass().getName()));
        this.functionExecutionInterface = functionExecutionInterface;
        this.gemfireFunctionOperations = gemfireFunctionOperations;
        this.methodMetadata = new DefaultFunctionExecutionMethodMetadata(functionExecutionInterface);
    }

    protected GemfireFunctionOperations getGemfireFunctionOperations() {
        return this.gemfireFunctionOperations;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)invocation.getMethod())) {
            return String.format("Function Proxy for interface [%s]", this.functionExecutionInterface.getName());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Invoking method {}", (Object)invocation.getMethod().getName());
        }
        return this.invokeFunction(invocation.getMethod(), invocation.getArguments());
    }

    protected Object invokeFunction(Method method, Object[] args) {
        return this.gemfireFunctionOperations.executeAndExtract(this.methodMetadata.getMethodMetadata(method).getFunctionId(), args);
    }

    public Object getObject() throws Exception {
        if (this.functionExecutionProxy == null) {
            this.onInit();
            Assert.notNull((Object)this.functionExecutionProxy, (String)"Failed to initialize Function Proxy");
        }
        return this.functionExecutionProxy;
    }

    public Class<?> getObjectType() {
        return this.functionExecutionInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void onInit() {
        if (!this.initialized) {
            ProxyFactory proxyFactory = new ProxyFactory(this.functionExecutionInterface, (Interceptor)this);
            this.functionExecutionProxy = proxyFactory.getProxy(this.beanClassLoader);
            this.initialized = true;
        }
    }
}

