/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Aspect
public class RegionDataAccessTracingAspect {
    private final Logger logger = this.newLogger();

    protected Logger newLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    protected String getCurrentThreadStackTrace() {
        StringWriter writer = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @Pointcut(value="target(org.apache.geode.cache.Region)")
    private void regionPointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.create(..)) || execution(* org.apache.geode.cache.Region.get(..)) || execution(* org.apache.geode.cache.Region.getAll(..)) || execution(* org.apache.geode.cache.Region.getEntry(..)) || execution(* org.apache.geode.cache.Region.invalidate(..)) || execution(* org.apache.geode.cache.Region.keySet()) || execution(* org.apache.geode.cache.Region.keySetOnServer()) || execution(* org.apache.geode.cache.Region.localClear()) || execution(* org.apache.geode.cache.Region.localDestroy(..)) || execution(* org.apache.geode.cache.Region.localInvalidate(..)) || execution(* org.apache.geode.cache.Region.put(..)) || execution(* org.apache.geode.cache.Region.putAll(..)) || execution(* org.apache.geode.cache.Region.putIfAbsent(..)) || execution(* org.apache.geode.cache.Region.query(..)) || execution(* org.apache.geode.cache.Region.remove(..)) || execution(* org.apache.geode.cache.Region.removeAll(..)) || execution(* org.apache.geode.cache.Region.replace(..)) || execution(* org.apache.geode.cache.Region.selectValue(..)) || execution(* org.apache.geode.cache.Region.size()) || execution(* org.apache.geode.cache.Region.sizeOnServer()) || execution(* org.apache.geode.cache.Region.values(..))")
    private void regionDataAccessPointcut() {
    }

    @Before(value="regionPointcut() && regionDataAccessPointcut()")
    public void regionDataAccessTracingAdvice(JoinPoint joinPoint) {
        this.getLogger().trace("Region data access call [{}(..)] with stack trace [{}]", (Object)this.toRegionMethodSignature(joinPoint), (Object)this.getCurrentThreadStackTrace());
    }

    private String toRegionMethodSignature(JoinPoint joinPoint) {
        return Optional.ofNullable(joinPoint).map(JoinPoint::getSignature).map(signature -> String.format("%1$s.%2$s", ObjectUtils.nullSafeClassName((Object)joinPoint.getTarget()), signature.getName())).orElse("");
    }
}

