/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.definitions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.springframework.data.gemfire.config.admin.GemfireAdminOperations;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefinition;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class RegionDefinition
extends SchemaObjectDefinition {
    protected static final int ORDER = 1;
    public static final RegionShortcut DEFAULT_REGION_SHORTCUT = RegionShortcut.PARTITION;
    private final transient Region<?, ?> region;
    private RegionShortcut regionShortcut;
    private String name;

    public static RegionDefinition from(Region<?, ?> region) {
        return Optional.ofNullable(region).map(RegionDefinition::new).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Region is required", new Object[0]));
    }

    protected RegionDefinition(Region<?, ?> region) {
        super(Optional.ofNullable(region).map(Region::getName).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Region is required", new Object[0])));
        this.region = region;
    }

    public int getOrder() {
        return 1;
    }

    protected Region<?, ?> getRegion() {
        return this.region;
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.name).filter(StringUtils::hasText).orElseGet(() -> super.getName());
    }

    public RegionShortcut getRegionShortcut() {
        return Optional.ofNullable(this.regionShortcut).orElse(DEFAULT_REGION_SHORTCUT);
    }

    @Override
    public SchemaObjectType getType() {
        return SchemaObjectType.REGION;
    }

    @Override
    public void create(GemfireAdminOperations gemfireAdminOperations) {
        gemfireAdminOperations.createRegion(this);
    }

    public RegionDefinition having(RegionShortcut regionShortcut) {
        this.regionShortcut = regionShortcut;
        return this;
    }

    public RegionDefinition with(String name) {
        this.name = name;
        return this;
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this.getName());
        outputStream.writeObject(this.getRegionShortcut());
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.name = inputStream.readUTF();
        this.regionShortcut = (RegionShortcut)inputStream.readObject();
    }
}

