/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.CacheServerConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableCacheServer;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableCacheServerConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.util.StringUtils;

public class AddCacheServerConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    @Autowired(required=false)
    private List<CacheServerConfigurer> cacheServerConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableCacheServer.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableCacheServerAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.registerCacheServerFactoryBeanDefinition(enableCacheServerAttributes, registry);
        }
    }

    protected void registerCacheServerFactoryBeanDefinition(AnnotationAttributes enableCacheServerAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CacheServerFactoryBean.class);
        String beanName = this.registerCacheServerFactoryBeanDefinition(builder.getBeanDefinition(), enableCacheServerAttributes.getString("name"), registry);
        builder.addPropertyReference("cache", "gemfireCache");
        builder.addPropertyValue("cacheServerConfigurers", this.resolveCacheServerConfigurers());
        builder.addPropertyValue("autoStartup", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "auto-startup"), this.resolveProperty(this.cacheServerProperty("auto-startup"), enableCacheServerAttributes.getBoolean("autoStartup"))));
        builder.addPropertyValue("bindAddress", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "bind-address"), this.resolveProperty(this.cacheServerProperty("bind-address"), enableCacheServerAttributes.getString("bindAddress"))));
        builder.addPropertyValue("hostNameForClients", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "hostname-for-clients"), this.resolveProperty(this.cacheServerProperty("hostname-for-clients"), enableCacheServerAttributes.getString("hostnameForClients"))));
        builder.addPropertyValue("loadPollInterval", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "load-poll-interval"), this.resolveProperty(this.cacheServerProperty("load-poll-interval"), (Long)enableCacheServerAttributes.getNumber("loadPollInterval"))));
        builder.addPropertyValue("maxConnections", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-connections"), this.resolveProperty(this.cacheServerProperty("max-connections"), (Integer)enableCacheServerAttributes.getNumber("maxConnections"))));
        builder.addPropertyValue("maxMessageCount", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-message-count"), this.resolveProperty(this.cacheServerProperty("max-message-count"), (Integer)enableCacheServerAttributes.getNumber("maxMessageCount"))));
        builder.addPropertyValue("maxThreads", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-threads"), this.resolveProperty(this.cacheServerProperty("max-threads"), (Integer)enableCacheServerAttributes.getNumber("maxThreads"))));
        builder.addPropertyValue("maxTimeBetweenPings", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "max-time-between-pings"), this.resolveProperty(this.cacheServerProperty("max-time-between-pings"), (Integer)enableCacheServerAttributes.getNumber("maxTimeBetweenPings"))));
        builder.addPropertyValue("messageTimeToLive", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "message-time-to-live"), this.resolveProperty(this.cacheServerProperty("message-time-to-live"), (Integer)enableCacheServerAttributes.getNumber("messageTimeToLive"))));
        builder.addPropertyValue("port", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "port"), this.resolveProperty(this.cacheServerProperty("port"), (Integer)enableCacheServerAttributes.getNumber("port"))));
        builder.addPropertyValue("socketBufferSize", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "socket-buffer-size"), this.resolveProperty(this.cacheServerProperty("socket-buffer-size"), (Integer)enableCacheServerAttributes.getNumber("socketBufferSize"))));
        builder.addPropertyValue("subscriptionCapacity", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-capacity"), this.resolveProperty(this.cacheServerProperty("subscription-capacity"), (Integer)enableCacheServerAttributes.getNumber("subscriptionCapacity"))));
        builder.addPropertyValue("subscriptionDiskStore", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-disk-store-name"), this.resolveProperty(this.cacheServerProperty("subscription-disk-store-name"), enableCacheServerAttributes.getString("subscriptionDiskStoreName"))));
        builder.addPropertyValue("subscriptionEvictionPolicy", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "subscription-eviction-policy"), SubscriptionEvictionPolicy.class, this.resolveProperty(this.cacheServerProperty("subscription-eviction-policy"), SubscriptionEvictionPolicy.class, enableCacheServerAttributes.getEnum("subscriptionEvictionPolicy"))));
        builder.addPropertyValue("tcpNoDelay", (Object)this.resolveProperty(this.namedCacheServerProperty(beanName, "tcp-no-delay"), this.resolveProperty(this.cacheServerProperty("tcp-no-delay"), enableCacheServerAttributes.getBoolean("tcpNoDelay"))));
    }

    private List<CacheServerConfigurer> resolveCacheServerConfigurers() {
        return Optional.ofNullable(this.cacheServerConfigurers).filter(cacheServerConfigurers -> !cacheServerConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableCacheServerConfigurer.create(this.getBeanFactory())));
    }

    protected String registerCacheServerFactoryBeanDefinition(AbstractBeanDefinition beanDefinition, String beanName, BeanDefinitionRegistry registry) {
        if (StringUtils.hasText((String)beanName)) {
            BeanDefinitionHolder beanDefinitionHolder = this.newBeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)registry);
            return beanName;
        }
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    protected BeanDefinitionHolder newBeanDefinitionHolder(BeanDefinition beanDefinition, String beanName) {
        return new BeanDefinitionHolder(beanDefinition, beanName);
    }
}

