/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query.support;

import org.apache.geode.cache.query.SelectResults;
import org.springframework.data.gemfire.repository.query.support.UnsupportedQueryExecutionException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.NonNull;

@FunctionalInterface
public interface OqlQueryExecutor {
    public static final String NON_EXECUTABLE_QUERY_MESSAGE = "OQL query [%1$s] is not executable by this executor [%2$s]";

    public SelectResults execute(QueryMethod var1, String var2, Object ... var3);

    default public UnsupportedQueryExecutionException newUnsupportedQueryExecutionException(String query) {
        return new UnsupportedQueryExecutionException(String.format(NON_EXECUTABLE_QUERY_MESSAGE, query, this.getClass().getName()));
    }

    default public OqlQueryExecutor thenExecuteWith(@NonNull OqlQueryExecutor queryExecutor) {
        return queryExecutor == null ? this : (queryMethod, query, arguments) -> {
            try {
                return this.execute(queryMethod, query, arguments);
            }
            catch (UnsupportedQueryExecutionException cause) {
                return queryExecutor.execute(queryMethod, query, arguments);
            }
        };
    }
}

