/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.util.ObjectSizer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.ResolvableRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableEviction;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.eviction.EvictingRegionFactoryBean;
import org.springframework.data.gemfire.eviction.EvictionActionType;
import org.springframework.data.gemfire.eviction.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.eviction.EvictionPolicyType;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
public class EvictionConfiguration
extends AbstractAnnotationConfigSupport
implements ApplicationContextAware,
ImportAware {
    private ApplicationContext applicationContext;
    private EvictionPolicyConfigurer evictionPolicyConfigurer;

    @Override
    @NonNull
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEviction.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableEvictionAttributes = this.getAnnotationAttributes(importMetadata);
            AnnotationAttributes[] policies = enableEvictionAttributes.getAnnotationArray("policies");
            for (AnnotationAttributes evictionPolicyAttributes : ArrayUtils.nullSafeArray(policies, AnnotationAttributes.class)) {
                this.evictionPolicyConfigurer = ComposableEvictionPolicyConfigurer.compose(this.evictionPolicyConfigurer, EvictionPolicyMetaData.from(evictionPolicyAttributes, this.applicationContext));
            }
            this.evictionPolicyConfigurer = Optional.ofNullable(this.evictionPolicyConfigurer).orElseGet(EvictionPolicyMetaData::fromDefaults);
        }
    }

    protected static boolean isRegionFactoryBean(Object bean) {
        return bean instanceof EvictingRegionFactoryBean;
    }

    protected EvictionPolicyConfigurer getEvictionPolicyConfigurer() {
        return Optional.ofNullable(this.evictionPolicyConfigurer).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("EvictionPolicyConfigurer was not properly configured and initialized", new Object[0]));
    }

    @Bean
    public BeanPostProcessor evictionBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return EvictionConfiguration.isRegionFactoryBean(bean) ? EvictionConfiguration.this.getEvictionPolicyConfigurer().configure(bean) : bean;
            }
        };
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void evictionContextRefreshedListener(@NonNull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        for (Region region : applicationContext.getBeansOfType(Region.class).values()) {
            this.getEvictionPolicyConfigurer().configure(region);
        }
    }

    protected static class EvictionPolicyMetaData
    implements EvictionPolicyConfigurer {
        protected static final String[] ALL_REGIONS = new String[0];
        private final EvictionAttributes evictionAttributes;
        private final Set<String> regionNames = new HashSet<String>();

        protected static EvictionPolicyMetaData from(@NonNull AnnotationAttributes evictionPolicyAttributes, @NonNull ApplicationContext applicationContext) {
            Assert.isAssignable(EnableEviction.EvictionPolicy.class, (Class)evictionPolicyAttributes.annotationType());
            return EvictionPolicyMetaData.from((EvictionPolicyType)evictionPolicyAttributes.getEnum("type"), (Integer)evictionPolicyAttributes.get((Object)"maximum"), (EvictionActionType)evictionPolicyAttributes.getEnum("action"), EvictionPolicyMetaData.resolveObjectSizer(evictionPolicyAttributes.getString("objectSizerName"), applicationContext), evictionPolicyAttributes.getStringArray("regionNames"));
        }

        protected static EvictionPolicyMetaData from(EnableEviction.EvictionPolicy evictionPolicy, ApplicationContext applicationContext) {
            return EvictionPolicyMetaData.from(evictionPolicy.type(), evictionPolicy.maximum(), evictionPolicy.action(), EvictionPolicyMetaData.resolveObjectSizer(evictionPolicy.objectSizerName(), applicationContext), evictionPolicy.regionNames());
        }

        protected static EvictionPolicyMetaData from(EvictionPolicyType type, int maximum, EvictionActionType action, ObjectSizer objectSizer, String ... regionNames) {
            EvictionAttributesFactoryBean factoryBean = new EvictionAttributesFactoryBean();
            factoryBean.setAction(action.getEvictionAction());
            factoryBean.setObjectSizer(objectSizer);
            factoryBean.setThreshold(EvictionPolicyMetaData.resolveThreshold(maximum, type));
            factoryBean.setType(type);
            factoryBean.afterPropertiesSet();
            return new EvictionPolicyMetaData(factoryBean.getObject(), regionNames);
        }

        protected static EvictionPolicyMetaData fromDefaults() {
            return new EvictionPolicyMetaData(EvictionAttributes.createLRUEntryAttributes());
        }

        protected static ObjectSizer resolveObjectSizer(String objectSizerName, ApplicationContext applicationContext) {
            boolean resolvable = StringUtils.hasText((String)objectSizerName) && applicationContext.containsBean(objectSizerName);
            return resolvable ? (ObjectSizer)applicationContext.getBean(objectSizerName, ObjectSizer.class) : null;
        }

        protected static Integer resolveThreshold(int maximum, EvictionPolicyType type) {
            return EvictionPolicyType.HEAP_PERCENTAGE.equals((Object)type) ? null : Integer.valueOf(maximum);
        }

        protected EvictionPolicyMetaData(EvictionAttributes evictionAttributes) {
            this(evictionAttributes, ALL_REGIONS);
        }

        protected EvictionPolicyMetaData(EvictionAttributes evictionAttributes, String[] regionNames) {
            Assert.notNull((Object)evictionAttributes, (String)"EvictionAttributes must not be null");
            this.evictionAttributes = evictionAttributes;
            Collections.addAll(this.regionNames, ArrayUtils.nullSafeArray(regionNames, String.class));
        }

        protected boolean accepts(@Nullable Object regionFactoryBean) {
            return EvictionConfiguration.isRegionFactoryBean(regionFactoryBean) && this.accepts(() -> this.resolveRegionName(regionFactoryBean));
        }

        protected boolean accepts(@Nullable Region<?, ?> region) {
            return region != null && this.accepts(() -> region.getName());
        }

        protected boolean accepts(Supplier<String> regionName) {
            return this.regionNames.isEmpty() || this.regionNames.contains(regionName.get());
        }

        protected String resolveRegionName(Object regionFactoryBean) {
            return regionFactoryBean instanceof ResolvableRegionFactoryBean ? ((ResolvableRegionFactoryBean)regionFactoryBean).resolveRegionName() : null;
        }

        protected EvictingRegionFactoryBean setEvictionAttributes(EvictingRegionFactoryBean regionFactoryBean) {
            regionFactoryBean.setEvictionAttributes(this.getEvictionAttributes());
            return regionFactoryBean;
        }

        protected EvictionAttributes getEvictionAttributes() {
            return Optional.ofNullable(this.evictionAttributes).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("EvictionAttributes was not properly configured and initialized", new Object[0]));
        }

        @Override
        public Object configure(Object regionBean) {
            return this.accepts(regionBean) ? this.setEvictionAttributes((EvictingRegionFactoryBean)regionBean) : regionBean;
        }

        @Override
        public Region<?, ?> configure(Region<?, ?> region) {
            Optional.ofNullable(region).filter(this::accepts).filter(this::isDefaultEvictionEntryMaximum).map(Region::getAttributesMutator).map(AttributesMutator::getEvictionAttributesMutator).ifPresent(evictionAttributesMutator -> evictionAttributesMutator.setMaximum(this.getEvictionAttributes().getMaximum()));
            return region;
        }

        private boolean isDefaultEvictionEntryMaximum(Region<?, ?> region) {
            return region != null && this.isDefaultEvictionEntryMaximum(region.getAttributes());
        }

        private boolean isDefaultEvictionEntryMaximum(RegionAttributes<?, ?> regionAttributes) {
            return regionAttributes != null && this.isDefaultEvictionEntryMaximum(regionAttributes.getEvictionAttributes());
        }

        private boolean isDefaultEvictionEntryMaximum(EvictionAttributes evictionAttributes) {
            return 900 == evictionAttributes.getMaximum();
        }
    }

    protected static class ComposableEvictionPolicyConfigurer
    implements EvictionPolicyConfigurer {
        private final EvictionPolicyConfigurer one;
        private final EvictionPolicyConfigurer two;

        @Nullable
        protected static EvictionPolicyConfigurer compose(EvictionPolicyConfigurer[] array) {
            return ComposableEvictionPolicyConfigurer.compose(Arrays.asList(ArrayUtils.nullSafeArray(array, EvictionPolicyConfigurer.class)));
        }

        @Nullable
        protected static EvictionPolicyConfigurer compose(Iterable<EvictionPolicyConfigurer> iterable) {
            EvictionPolicyConfigurer current = null;
            for (EvictionPolicyConfigurer evictionPolicyConfigurer : CollectionUtils.nullSafeIterable(iterable)) {
                current = ComposableEvictionPolicyConfigurer.compose(current, evictionPolicyConfigurer);
            }
            return current;
        }

        @Nullable
        protected static EvictionPolicyConfigurer compose(@Nullable EvictionPolicyConfigurer one, @Nullable EvictionPolicyConfigurer two) {
            return one == null ? two : (two == null ? one : new ComposableEvictionPolicyConfigurer(one, two));
        }

        private ComposableEvictionPolicyConfigurer(EvictionPolicyConfigurer one, EvictionPolicyConfigurer two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public Object configure(Object regionBean) {
            return this.two.configure(this.one.configure(regionBean));
        }

        @Override
        public Region<?, ?> configure(Region<?, ?> region) {
            return this.two.configure(this.one.configure(region));
        }
    }

    @FunctionalInterface
    protected static interface EvictionPolicyConfigurer {
        public Object configure(Object var1);

        default public Region<?, ?> configure(Region<?, ?> region) {
            return region;
        }
    }
}

