/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.Optional;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.internal.cache.LocalRegion;
import org.springframework.data.gemfire.client.ClientRegionShortcutWrapper;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class RegionUtils
extends CacheUtils {
    public static void assertClientRegionShortcutAndPersistentAttributeAreCompatible(ClientRegionShortcut clientRegionShortcut, Boolean persistent) {
        boolean persistentUnspecified;
        boolean bl = persistentUnspecified = persistent == null;
        if (ClientRegionShortcutWrapper.valueOf(clientRegionShortcut).isPersistent()) {
            Assert.isTrue((persistentUnspecified || Boolean.TRUE.equals(persistent) ? 1 : 0) != 0, (String)String.format("Client Region Shortcut [%s] is not valid when persistent is false", clientRegionShortcut));
        } else {
            Assert.isTrue((persistentUnspecified || Boolean.FALSE.equals(persistent) ? 1 : 0) != 0, (String)String.format("Client Region Shortcut [%s] is not valid when persistent is true", clientRegionShortcut));
        }
    }

    public static void assertDataPolicyAndPersistentAttributeAreCompatible(DataPolicy dataPolicy, Boolean persistent) {
        boolean persistentUnspecified;
        boolean bl = persistentUnspecified = persistent == null;
        if (dataPolicy.withPersistence()) {
            Assert.isTrue((persistentUnspecified || Boolean.TRUE.equals(persistent) ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is not valid when persistent is false", dataPolicy));
        } else {
            Assert.isTrue((persistentUnspecified || Boolean.FALSE.equals(persistent) ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is not valid when persistent is true", dataPolicy));
        }
    }

    public static boolean close(Region<?, ?> region) {
        try {
            region.close();
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static boolean isClient(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).filter(StringUtils::hasText).isPresent();
    }

    public static boolean isCloseable(Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getRegionService).filter(regionService -> !regionService.isClosed()).isPresent();
    }

    public static boolean isLocal(@Nullable Region<?, ?> region) {
        return region instanceof LocalRegion;
    }

    @Nullable
    public static String toRegionName(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getName).orElse(null);
    }

    @Nullable
    public static String toRegionName(String regionPath) {
        return Optional.ofNullable(regionPath).filter(StringUtils::hasText).map(StringUtils::trimWhitespace).map(it -> it.lastIndexOf("/")).filter(index -> index > -1).map(index -> regionPath.substring(index + 1)).orElse(regionPath);
    }

    @Nullable
    public static String toRegionPath(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getFullPath).orElse(null);
    }

    @NonNull
    public static String toRegionPath(String regionName) {
        return String.format("%1$s%2$s", "/", regionName);
    }

    public static boolean isServer(@Nullable Region<?, ?> region) {
        return region != null && !RegionUtils.isClient(region);
    }
}

