/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.batch.pig;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.data.hadoop.pig.PigExecutor;
import org.springframework.util.CollectionUtils;

public class PigTasklet
extends PigExecutor
implements Tasklet {
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        List<ExecJob> execs = this.executePigScripts();
        this.saveStats(execs, contribution);
        return RepeatStatus.FINISHED;
    }

    private void saveStats(List<ExecJob> execs, StepContribution contribution) throws Exception {
        if (CollectionUtils.isEmpty(execs) || contribution == null) {
            return;
        }
        for (ExecJob execJob : execs) {
            PigStats stats = execJob.getStatistics();
            if (stats == null || stats.getClass().getName().contains("EmbeddedPigStats")) continue;
            List inputStats = stats.getInputStats();
            for (InputStats is : inputStats) {
                for (int i = 0; i < PigTasklet.safeLongToInt(is.getNumberRecords()); ++i) {
                    contribution.incrementReadCount();
                }
            }
            contribution.incrementWriteCount(PigTasklet.safeLongToInt(stats.getRecordWritten()));
        }
    }

    static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }
}

