/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.pig.backend.executionengine.ExecJob;
import org.springframework.data.hadoop.pig.PigExecutor;

public class PigRunner
extends PigExecutor
implements Callable<List<ExecJob>> {
    private boolean runAtStartup = false;
    private Iterable<Callable<?>> preActions;
    private Iterable<Callable<?>> postActions;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.runAtStartup) {
            this.call();
        }
    }

    @Override
    public List<ExecJob> call() throws Exception {
        this.invoke(this.preActions);
        List<ExecJob> result = this.executePigScripts();
        this.invoke(this.postActions);
        return result;
    }

    public void setRunAtStartup(boolean runAtStartup) {
        this.runAtStartup = runAtStartup;
    }

    public void setPreAction(Collection<Callable<?>> actions) {
        this.preActions = actions;
    }

    public void setPostAction(Collection<Callable<?>> actions) {
        this.postActions = actions;
    }

    private void invoke(Iterable<Callable<?>> actions) throws Exception {
        if (actions != null) {
            for (Callable<?> action : actions) {
                action.call();
            }
        }
    }
}

