/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.config.annotation.builders;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.config.common.annotation.AbstractConfiguredAnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.ObjectPostProcessor;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.codec.Codecs;
import org.springframework.data.hadoop.store.config.annotation.SpringDataStoreWriterConfigs;
import org.springframework.data.hadoop.store.config.annotation.builders.DataStoreTextWriterConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.DefaultNamingStrategyConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.DefaultPartitionStrategyConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.DefaultRolloverStrategyConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.NamingStrategyConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.PartitionStrategyConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.RolloverStrategyConfigurer;
import org.springframework.data.hadoop.store.partition.PartitionStrategy;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;

public final class DataStoreTextWriterBuilder
extends AbstractConfiguredAnnotationBuilder<SpringDataStoreWriterConfigs, DataStoreTextWriterConfigurer, DataStoreTextWriterBuilder>
implements DataStoreTextWriterConfigurer {
    private Configuration configuration;
    private Path basePath;
    private CodecInfo codec;
    private PartitionStrategy<?, ?> partitionStrategy;
    private FileNamingStrategy fileNamingStrategy;
    private RolloverStrategy rolloverStrategy;
    private Boolean overwrite;
    private Boolean appendable;
    private Long idleTimeout;
    private Long closeTimeout;
    private Integer fileOpenAttempts;
    private String inWritingPrefix;
    private String inWritingSuffix;

    public DataStoreTextWriterBuilder() {
    }

    public DataStoreTextWriterBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    protected SpringDataStoreWriterConfigs performBuild() throws Exception {
        SpringDataStoreWriterConfigs configs = new SpringDataStoreWriterConfigs();
        configs.setConfiguration(this.configuration);
        configs.setBasePath(this.basePath);
        configs.setCodec(this.codec);
        configs.setPartitionStrategy(this.partitionStrategy);
        configs.setFileNamingStrategy(this.fileNamingStrategy);
        configs.setRolloverStrategy(this.rolloverStrategy);
        configs.setOverwrite(this.overwrite);
        configs.setAppendable(this.appendable);
        configs.setIdleTimeout(this.idleTimeout);
        configs.setCloseTimeout(this.closeTimeout);
        configs.setFileOpenAttempts(this.fileOpenAttempts);
        configs.setInWritingPrefix(this.inWritingPrefix);
        configs.setInWritingSuffix(this.inWritingSuffix);
        return configs;
    }

    @Override
    public DataStoreTextWriterConfigurer configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer basePath(Path basePath) {
        this.basePath = basePath;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer basePath(String basePath) {
        return this.basePath(new Path(basePath));
    }

    @Override
    public DataStoreTextWriterConfigurer codec(CodecInfo codec) {
        this.codec = codec;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer codec(String codec) {
        return this.codec(Codecs.getCodecInfo(codec));
    }

    @Override
    public DataStoreTextWriterConfigurer codec(Codecs codec) {
        return this.codec(codec.getCodecInfo());
    }

    @Override
    public DataStoreTextWriterConfigurer overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer append(boolean append) {
        this.appendable = append;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer inWritingPrefix(String prefix) {
        this.inWritingPrefix = prefix;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer inWritingSuffix(String suffix) {
        this.inWritingSuffix = suffix;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer idleTimeout(long timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer closeTimeout(long timeout) {
        this.closeTimeout = timeout;
        return this;
    }

    @Override
    public DataStoreTextWriterConfigurer fileOpenAttempts(int attempts) {
        this.fileOpenAttempts = attempts;
        return this;
    }

    @Override
    public PartitionStrategyConfigurer withPartitionStrategy() throws Exception {
        return (PartitionStrategyConfigurer)this.apply(new DefaultPartitionStrategyConfigurer());
    }

    @Override
    public NamingStrategyConfigurer withNamingStrategy() throws Exception {
        return (NamingStrategyConfigurer)this.apply(new DefaultNamingStrategyConfigurer());
    }

    @Override
    public RolloverStrategyConfigurer withRolloverStrategy() throws Exception {
        return (RolloverStrategyConfigurer)this.apply(new DefaultRolloverStrategyConfigurer());
    }

    public void setPartitionStrategy(PartitionStrategy<?, ?> partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setFileNamingStrategy(FileNamingStrategy fileNamingStrategy) {
        this.fileNamingStrategy = fileNamingStrategy;
    }

    public void setRolloverStrategy(RolloverStrategy rolloverStrategy) {
        this.rolloverStrategy = rolloverStrategy;
    }
}

