/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Flushable;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetStoreObjectSupport;
import org.springframework.util.Assert;

public abstract class AbstractDatasetStoreWriter<T, R>
extends DatasetStoreObjectSupport
implements DataStoreWriter<T> {
    private static final Log log = LogFactory.getLog(AbstractDatasetStoreWriter.class);
    private Class<T> entityClass;
    private DatasetRepositoryFactory datasetRepositoryFactory;
    private DatasetDefinition datasetDefinition;
    private DatasetWriter<R> writer;
    private final Object lock = new Object();

    protected AbstractDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        Assert.notNull(entityClass, (String)"You must specify 'entityClass'");
        Assert.notNull((Object)datasetRepositoryFactory, (String)"You must provide a 'datasetRepositoryFactory'");
        Assert.notNull((Object)datasetDefinition, (String)"You must provide a 'datasetDefinition'");
        this.entityClass = entityClass;
        this.datasetRepositoryFactory = datasetRepositoryFactory;
        this.datasetDefinition = datasetDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T entity) throws IOException {
        if (this.writer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.writer == null) {
                    this.writer = this.createWriter();
                }
            }
        }
        this.writer.write(this.convertEntity(entity));
        this.resetIdleTimeout();
    }

    @Override
    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushing writer " + this.writer));
        }
        if (this.writer != null && this.writer instanceof Flushable) {
            ((Flushable)this.writer).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing writer " + this.writer));
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    protected void handleTimeout() {
        log.info((Object)"Timeout detected, closing writer");
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract R convertEntity(T var1);

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected DatasetRepositoryFactory getDatasetRepositoryFactory() {
        return this.datasetRepositoryFactory;
    }

    protected DatasetDefinition getDatasetDefinition() {
        return this.datasetDefinition;
    }

    protected abstract DatasetWriter<R> createWriter();
}

