/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Formats;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.dataset.AbstractDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetUtils;
import org.springframework.util.Assert;

public class AvroPojoDatasetStoreWriter<T>
extends AbstractDatasetStoreWriter<T, T> {
    public AvroPojoDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory) {
        this(entityClass, datasetRepositoryFactory, new DatasetDefinition(entityClass, false, Formats.AVRO.getName()));
    }

    public AvroPojoDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        super(entityClass, datasetRepositoryFactory, datasetDefinition);
    }

    @Override
    public void write(T entity) throws IOException {
        Assert.notNull(entity, (String)"Entity to be written can't be 'null'.");
        if (!entity.getClass().equals(this.getEntityClass())) {
            throw new IllegalArgumentException("Entity to write is of class " + entity.getClass().getName() + ". Expected " + this.getEntityClass().getName());
        }
        super.write(entity);
    }

    @Override
    protected DatasetWriter<T> createWriter() {
        if (Formats.AVRO.getName().equals(this.getDatasetDefinition().getFormat().getName())) {
            Dataset dataset = DatasetUtils.getOrCreateDataset(this.getDatasetRepositoryFactory(), this.getDatasetDefinition(), this.getEntityClass(), this.getEntityClass());
            return dataset.newWriter();
        }
        throw new StoreException("Invalid format " + this.getDatasetDefinition().getFormat() + " specified, you must use 'avro' with " + this.getClass().getSimpleName() + ".");
    }

    @Override
    protected T convertEntity(T entity) {
        return entity;
    }
}

