/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.Arrays;
import java.util.List;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;

public class HashRangeMethodExecutor
implements MethodExecutor {
    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        if (arguments[1] instanceof List) {
            return new TypedValue((Object)HashRangeMethodExecutor.rangeWithObjectAndList(arguments[0], (List)arguments[1]));
        }
        throw new AccessException("Argument " + arguments[1] + " not a List");
    }

    public static String range(Object arg1, List<?> arg2) throws AccessException {
        return HashRangeMethodExecutor.rangeWithObjectAndList(arg1, arg2);
    }

    private static String rangeWithObjectAndList(Object arg1, List<?> arg2) throws AccessException {
        try {
            Object[] ranges = arg2.toArray(new Object[0]);
            int searchIndex = Arrays.binarySearch(ranges, arg1);
            return ranges[Math.min(searchIndex < 0 ? -searchIndex - 1 : searchIndex, ranges.length - 1)] + "_range";
        }
        catch (Exception e) {
            throw new AccessException("Error finding range", e);
        }
    }
}

