/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.DataStoreReader;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.input.TextFileReader;
import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.support.StoreUtils;
import org.springframework.util.StringUtils;

public class DelimitedTextFileReader
implements DataStoreReader<List<String>> {
    public static final byte[] CSV = StoreUtils.getUTF8CsvDelimiter();
    public static final byte[] TAB = StoreUtils.getUTF8TabDelimiter();
    private TextFileReader textFileReader;
    private final String fieldDelimiter;

    public DelimitedTextFileReader(Configuration configuration, Path basePath, CodecInfo codec) {
        this(configuration, basePath, codec, null, CSV, null);
    }

    public DelimitedTextFileReader(Configuration configuration, Path basePath, CodecInfo codec, byte[] fieldDelimiter) {
        this(configuration, basePath, codec, null, fieldDelimiter, null);
    }

    public DelimitedTextFileReader(Configuration configuration, Path basePath, CodecInfo codec, Split inputSplit, byte[] fieldDelimiter, byte[] textDelimiter) {
        this.fieldDelimiter = new String(fieldDelimiter);
        this.textFileReader = new TextFileReader(configuration, basePath, codec, inputSplit, textDelimiter);
    }

    @Override
    public List<String> read() throws IOException {
        String line = this.textFileReader.read();
        return StringUtils.hasText((String)line) ? Arrays.asList(line.split(this.fieldDelimiter)) : null;
    }

    @Override
    public void close() throws IOException {
        this.textFileReader.close();
    }
}

