/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.context.Lifecycle;
import org.springframework.data.hadoop.store.DataStoreWriter;
import org.springframework.data.hadoop.store.PartitionDataStoreWriter;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.partition.PartitionStrategy;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategyFactory;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategyFactory;
import org.springframework.data.hadoop.store.support.LifecycleObjectSupport;
import org.springframework.util.Assert;

public abstract class AbstractPartitionDataStoreWriter<T, K>
extends LifecycleObjectSupport
implements PartitionDataStoreWriter<T, K> {
    private static final Log log = LogFactory.getLog(AbstractPartitionDataStoreWriter.class);
    private final Configuration configuration;
    private final Path basePath;
    private final CodecInfo codec;
    private final PartitionStrategy<T, K> partitionStrategy;
    private final Map<Path, DataStoreWriter<T>> writers = new ConcurrentHashMap<Path, DataStoreWriter<T>>();
    private DataStoreWriter<T> fallbackWriter;
    private FileNamingStrategyFactory<FileNamingStrategy> fileNamingStrategyFactory;
    private RolloverStrategyFactory<RolloverStrategy> rolloverStrategyFactory;
    private long idleTimeout;
    private long closeTimeout;
    private long flushTimeout;
    private boolean append = false;
    private int maxOpenAttempts = 10;
    private String suffix;
    private String prefix;
    private boolean overwrite = false;
    private volatile boolean closed = false;
    private boolean syncable = false;

    public AbstractPartitionDataStoreWriter(Configuration configuration, Path basePath, CodecInfo codec, PartitionStrategy<T, K> partitionStrategy) {
        this.configuration = configuration;
        this.basePath = basePath;
        this.codec = codec;
        this.partitionStrategy = partitionStrategy;
        Assert.notNull(partitionStrategy, (String)"Partition strategy must be set");
    }

    @Override
    public void write(T entity) throws IOException {
        this.write(entity, this.partitionStrategy.getPartitionKeyResolver().resolvePartitionKey(entity));
    }

    @Override
    public void flush() throws IOException {
        for (DataStoreWriter<T> writer : this.writers.values()) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                log.warn((Object)"Writer caused exception in flush", (Throwable)e);
            }
        }
        if (this.fallbackWriter != null) {
            try {
                this.fallbackWriter.flush();
            }
            catch (Exception e) {
                log.warn((Object)"Writer caused exception in flush", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (DataStoreWriter<T> writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (Exception e) {
                log.warn((Object)"Writer caused exception in close", (Throwable)e);
            }
        }
        this.writers.clear();
        if (this.fallbackWriter != null) {
            try {
                this.fallbackWriter.close();
            }
            catch (Exception e) {
                log.warn((Object)"Writer caused exception in close", (Throwable)e);
            }
            this.fallbackWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(T entity, K partitionKey) throws IOException {
        if (this.isClosed()) {
            throw new StoreException("This writer is already closed");
        }
        DataStoreWriter<T> writer = null;
        Path path = null;
        Map<Path, DataStoreWriter<T>> map = this.writers;
        synchronized (map) {
            if (partitionKey != null) {
                path = this.partitionStrategy.getPartitionResolver().resolvePath(partitionKey);
                writer = this.writers.get(path);
            } else if (this.fallbackWriter == null) {
                writer = this.createWriter(this.getConfiguration(), null, this.getCodec());
                this.fallbackWriter = writer;
            }
            if (writer == null) {
                writer = this.createWriter(this.getConfiguration(), path, this.getCodec());
                this.writers.put(path, writer);
            }
        }
        writer.write(entity);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected void doStart() {
        super.doStart();
    }

    @Override
    protected void doStop() {
        this.closed = true;
        for (DataStoreWriter<T> w : this.writers.values()) {
            if (!(w instanceof Lifecycle)) continue;
            try {
                log.info((Object)("Stopping writer=[" + w + "]"));
                ((Lifecycle)w).stop();
            }
            catch (Exception e) {
                log.warn((Object)("Error closing DataStoreWriter " + w), (Throwable)e);
            }
        }
        try {
            this.flush();
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFileNamingStrategyFactory(FileNamingStrategyFactory<FileNamingStrategy> fileNamingStrategyFactory) {
        this.fileNamingStrategyFactory = fileNamingStrategyFactory;
    }

    public FileNamingStrategyFactory<FileNamingStrategy> getFileNamingStrategyFactory() {
        return this.fileNamingStrategyFactory;
    }

    public void setRolloverStrategyFactory(RolloverStrategyFactory<RolloverStrategy> rolloverStrategyFactory) {
        this.rolloverStrategyFactory = rolloverStrategyFactory;
    }

    public RolloverStrategyFactory<RolloverStrategy> getRolloverStrategyFactory() {
        return this.rolloverStrategyFactory;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setFlushTimeout(long flushTimeout) {
        this.flushTimeout = flushTimeout;
    }

    public void setInWritingSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getInWritingSuffix() {
        return this.suffix;
    }

    public void setInWritingPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getInWritingPrefix() {
        return this.prefix;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        log.info((Object)("Setting overwrite to " + overwrite));
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isAppendable() {
        return this.append;
    }

    public void setAppendable(boolean append) {
        this.append = append;
    }

    public boolean isSyncable() {
        return this.syncable;
    }

    public void setSyncable(boolean syncable) {
        this.syncable = syncable;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public long getFlushTimeout() {
        return this.flushTimeout;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public CodecInfo getCodec() {
        return this.codec;
    }

    public void setMaxOpenAttempts(int maxOpenAttempts) {
        this.maxOpenAttempts = maxOpenAttempts;
    }

    public int getMaxOpenAttempts() {
        return this.maxOpenAttempts;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected abstract DataStoreWriter<T> createWriter(Configuration var1, Path var2, CodecInfo var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyWriter(Path path) {
        log.info((Object)("Trying to destoy writer with path=[" + path + "]"));
        if (path == null) {
            return;
        }
        Map<Path, DataStoreWriter<T>> map = this.writers;
        synchronized (map) {
            DataStoreWriter<T> writer = this.writers.remove(path);
            if (writer != null) {
                log.info((Object)("Removed writer=[" + writer + "]"));
            } else {
                log.info((Object)("Writer with path=[" + path + "] didn't exist anymore"));
            }
        }
    }
}

