/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.split;

import org.apache.hadoop.conf.Configuration;
import org.springframework.data.hadoop.store.split.SlopBlockSplitter;

public class StaticBlockSplitter
extends SlopBlockSplitter {
    private int splits;

    public StaticBlockSplitter() {
        this(null, 0);
    }

    public StaticBlockSplitter(Configuration configuration) {
        this(configuration, 0);
    }

    public StaticBlockSplitter(Configuration configuration, int splits) {
        super(configuration);
        this.splits = splits;
    }

    @Override
    protected long computeSplitSize(long blockSize, long minSize, long maxSize) {
        if (this.splits > 0) {
            return blockSize / (long)(this.splits + 1);
        }
        return blockSize;
    }

    public void setSplits(int splits) {
        this.splits = splits;
    }
}

