/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.rollover.RolloverStrategy;
import org.springframework.data.hadoop.store.support.OutputContext;
import org.springframework.data.hadoop.store.support.StoreObjectSupport;
import org.springframework.util.StringUtils;

public abstract class OutputStoreObjectSupport
extends StoreObjectSupport {
    private static final Log log = LogFactory.getLog(OutputStoreObjectSupport.class);
    private OutputContext outputContext = new OutputContext();
    private boolean internalInitDone;
    private String suffix;
    private String prefix;
    private boolean overwrite = false;
    private boolean append = false;
    private boolean syncable = false;

    public OutputStoreObjectSupport(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
        this.outputContext.setCodecInfo(codec);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        try {
            this.initOutputContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void initOutputContext() throws Exception {
        if (this.internalInitDone) {
            return;
        }
        for (FileStatus status : this.findInitFiles(this.getPath())) {
            Path path;
            String name = status.getPath().getName();
            if (StringUtils.hasText((String)this.prefix) && name.startsWith(this.prefix)) {
                name = name.substring(this.prefix.length());
            }
            if (StringUtils.hasText((String)this.suffix) && name.endsWith(this.suffix)) {
                name = name.substring(0, name.length() - this.suffix.length());
            }
            if (this.outputContext.init(path = new Path(status.getPath().getParent(), name)) == null) break;
        }
        this.internalInitDone = true;
    }

    protected FileStatus[] findInitFiles(Path basePath) throws Exception {
        FileSystem fileSystem = basePath.getFileSystem(this.getConfiguration());
        if (fileSystem.exists(basePath)) {
            FileStatus[] fileStatuses = fileSystem.listStatus(basePath);
            Arrays.sort(fileStatuses, new Comparator<FileStatus>(){

                @Override
                public int compare(FileStatus f1, FileStatus f2) {
                    return -Long.valueOf(f1.getModificationTime()).compareTo(f2.getModificationTime());
                }
            });
            return fileStatuses;
        }
        return new FileStatus[0];
    }

    public OutputContext getOutputContext() {
        if (!this.internalInitDone) {
            try {
                this.initOutputContext();
            }
            catch (Exception e) {
                throw new StoreException("Store output context not yet initialized", e);
            }
        }
        return this.outputContext;
    }

    public void setFileNamingStrategy(FileNamingStrategy fileNamingStrategy) {
        this.outputContext.setFileNamingStrategy(fileNamingStrategy);
        this.outputContext.setCodecInfo(this.getCodec());
    }

    public void setRolloverStrategy(RolloverStrategy rolloverStrategy) {
        this.outputContext.setRolloverStrategy(rolloverStrategy);
    }

    public void setInWritingSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setInWritingPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        log.info((Object)("Setting overwrite to " + overwrite));
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isAppendable() {
        return this.append;
    }

    public void setAppendable(boolean append) {
        this.append = append;
    }

    public boolean isSyncable() {
        return this.syncable;
    }

    public void setSyncable(boolean syncable) {
        this.syncable = syncable;
    }

    protected Path getResolvedPath() {
        Path p = this.outputContext != null ? this.outputContext.resolvePath(this.getPath()) : this.getPath();
        if (this.isFileWriteable(p)) {
            throw new StoreException("Path [" + p + "] exists and overwritten not allowed");
        }
        String name = (StringUtils.hasText((String)this.prefix) ? this.prefix : "") + p.getName() + (StringUtils.hasText((String)this.suffix) ? this.suffix : "");
        if (this.isFileWriteable(p = new Path(p.getParent(), name))) {
            throw new StoreException("Path [" + p + "] exists and overwritten not allowed");
        }
        return p;
    }

    protected boolean isFileWriteable(Path p) {
        return !this.overwrite && this.pathExists(p) && !this.append;
    }

    protected void setWritePosition(long position) {
        this.outputContext.setWritePosition(position);
        this.resetIdleTimeout();
    }

    protected Path renameFile(Path path) {
        log.debug((Object)("renameFile called with path=[" + path + "]"));
        if (!StringUtils.hasText((String)this.prefix) && !StringUtils.hasText((String)this.suffix)) {
            return path;
        }
        String name = path.getName();
        if (StringUtils.startsWithIgnoreCase((String)name, (String)this.prefix)) {
            name = name.substring(this.prefix.length());
        }
        if (StringUtils.endsWithIgnoreCase((String)name, (String)this.suffix)) {
            name = name.substring(0, name.length() - this.suffix.length());
        }
        Path toPath = new Path(path.getParent(), name);
        try {
            boolean succeed;
            FileSystem fs = path.getFileSystem(this.getConfiguration());
            try {
                fs.delete(toPath, false);
                log.info((Object)("Renaming path=[" + path + "] toPath=[" + toPath + "]"));
                succeed = fs.rename(path, toPath);
            }
            catch (Exception e) {
                throw new StoreException("Failed renaming from " + path + " to " + toPath, e);
            }
            if (!succeed) {
                throw new StoreException("Failed renaming from " + path + " to " + toPath + " because hdfs returned false");
            }
        }
        catch (IOException e) {
            log.error((Object)"Error renaming file", (Throwable)e);
            throw new StoreException("Error renaming file", e);
        }
        return toPath;
    }

    private boolean pathExists(Path path) {
        try {
            return path.getFileSystem(this.getConfiguration()).exists(path);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

