/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import java.util.List;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.config.namespace.NamespaceUtils;
import org.springframework.data.hadoop.scripting.HdfsScriptRunner;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ScriptParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        return !"location".equals(attributeName) && !"pre-action".equals(attributeName) && !"post-action".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder b;
        super.doParse(element, parserContext, builder);
        NamespaceUtils.setCSVProperty(element, builder, "pre-action", "preAction");
        NamespaceUtils.setCSVProperty(element, builder, "post-action", "postAction");
        String scope = element.getAttribute("scope");
        if (StringUtils.hasText((String)scope)) {
            builder.setScope(scope);
        }
        String location = element.getAttribute("location");
        String inline = DomUtils.getTextValue((Element)element);
        boolean hasScriptInlined = StringUtils.hasText((String)inline);
        AbstractBeanDefinition scriptSource = null;
        if (StringUtils.hasText((String)location)) {
            if (hasScriptInlined) {
                parserContext.getReaderContext().error("cannot specify both 'location' and a nested script; use only one", (Object)element);
            }
            b = BeanDefinitionBuilder.genericBeanDefinition(ResourceScriptSource.class);
            b.addConstructorArgValue((Object)location);
            scriptSource = b.getBeanDefinition();
        } else {
            if (!hasScriptInlined) {
                parserContext.getReaderContext().error("no 'location' or nested script specified", (Object)element);
            }
            b = BeanDefinitionBuilder.genericBeanDefinition(StaticScriptSource.class);
            b.addConstructorArgValue((Object)inline);
            b.addConstructorArgValue((Object)element.getAttribute("id"));
            scriptSource = b.getBeanDefinition();
        }
        builder.addPropertyValue("scriptSource", (Object)scriptSource);
        if (!element.hasAttribute("language")) {
            if (hasScriptInlined) {
                parserContext.getReaderContext().error("the language needs to be specified when using an inlined script", (Object)element);
            }
            builder.addPropertyValue("extension", (Object)StringUtils.getFilenameExtension((String)location));
        }
        GenericBeanDefinition bd = new GenericBeanDefinition();
        parserContext.getDelegate().parsePropertyElements(element, (BeanDefinition)bd);
        ManagedMap args = new ManagedMap();
        List list = bd.getPropertyValues().getPropertyValueList();
        for (PropertyValue pv : list) {
            args.put((Object)pv.getName(), pv.getValue());
        }
        builder.addPropertyValue("arguments", (Object)args);
    }

    protected Class<?> getBeanClass(Element element) {
        return HdfsScriptRunner.class;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

