/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class HadoopResourceLoaderParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    HadoopResourceLoaderParser() {
    }

    protected Class<HdfsResourceLoader> getBeanClass(Element element) {
        return HdfsResourceLoader.class;
    }

    @Override
    protected String defaultId(ParserContext context, Element element) {
        return "hadoopResourceLoader";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String handleNoprefix;
        String depends = element.getAttribute("depends-on");
        if (StringUtils.hasText((String)depends)) {
            builder.getRawBeanDefinition().setDependsOn(StringUtils.tokenizeToStringArray((String)depends, (String)",; "));
        }
        String fs = element.getAttribute("file-system-ref");
        String config = element.getAttribute("configuration-ref");
        String uri = element.getAttribute("uri");
        String user = element.getAttribute("user");
        if (StringUtils.hasText((String)fs)) {
            if (StringUtils.hasText((String)uri)) {
                parserContext.getReaderContext().error("cannot specify both 'uri' and a the file system; use only one", (Object)element);
            }
            builder.addConstructorArgReference(fs.trim());
        } else {
            builder.addConstructorArgReference(config.trim());
            if (StringUtils.hasText((String)uri)) {
                builder.addConstructorArgValue((Object)uri);
                if (StringUtils.hasText((String)user)) {
                    builder.addConstructorArgValue((Object)user);
                }
            } else if (StringUtils.hasText((String)user)) {
                parserContext.getReaderContext().error("attribute 'user' need to be defined together with 'uri'; use both", (Object)element);
            }
        }
        String useCodecs = element.getAttribute("use-codecs");
        if (StringUtils.hasText((String)useCodecs)) {
            builder.addPropertyValue("useCodecs", (Object)useCodecs);
        }
        if (StringUtils.hasText((String)(handleNoprefix = element.getAttribute("handle-noprefix")))) {
            builder.addPropertyValue("handleNoprefix", (Object)handleNoprefix);
        }
        this.postProcess(builder, element);
    }
}

