/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.EntityRowMapper;
import org.springframework.data.jdbc.repository.RowMapperMap;
import org.springframework.data.jdbc.repository.support.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

class JdbcQueryLookupStrategy
implements QueryLookupStrategy {
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    private final RelationalConverter converter;
    private final DataAccessStrategy accessStrategy;
    private final RowMapperMap rowMapperMap;
    private final NamedParameterJdbcOperations operations;

    JdbcQueryLookupStrategy(ApplicationEventPublisher publisher, RelationalMappingContext context, RelationalConverter converter, DataAccessStrategy accessStrategy, RowMapperMap rowMapperMap, NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)publisher, (String)"Publisher must not be null!");
        Assert.notNull((Object)((Object)context), (String)"RelationalMappingContext must not be null!");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null!");
        Assert.notNull((Object)accessStrategy, (String)"DataAccessStrategy must not be null!");
        Assert.notNull((Object)rowMapperMap, (String)"RowMapperMap must not be null!");
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = accessStrategy;
        this.rowMapperMap = rowMapperMap;
        this.operations = operations;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        JdbcQueryMethod queryMethod = new JdbcQueryMethod(method, repositoryMetadata, projectionFactory);
        RowMapper<?> rowMapper = queryMethod.isModifyingQuery() ? null : this.createRowMapper(queryMethod);
        return new JdbcRepositoryQuery(this.publisher, this.context, queryMethod, this.operations, rowMapper);
    }

    private RowMapper<?> createRowMapper(JdbcQueryMethod queryMethod) {
        Class returnedObjectType = queryMethod.getReturnedObjectType();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance((Class)returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultRowMapper(queryMethod);
    }

    private RowMapper<?> determineDefaultRowMapper(JdbcQueryMethod queryMethod) {
        Class domainType = queryMethod.getReturnedObjectType();
        EntityRowMapper typeMappedRowMapper = this.rowMapperMap.rowMapperFor(domainType);
        return typeMappedRowMapper == null ? new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType), this.context, this.converter, this.accessStrategy) : typeMappedRowMapper;
    }
}

