/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public final class JdbcUtil {
    private static final Map<Class<?>, Integer> sqlTypeMappings = new HashMap();

    public static int sqlTypeFor(Class<?> type) {
        return sqlTypeMappings.keySet().stream().filter(k -> k.isAssignableFrom(type)).findFirst().map(sqlTypeMappings::get).orElse(Integer.MIN_VALUE);
    }

    private JdbcUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        sqlTypeMappings.put(String.class, 12);
        sqlTypeMappings.put(BigInteger.class, -5);
        sqlTypeMappings.put(BigDecimal.class, 2);
        sqlTypeMappings.put(Byte.class, -6);
        sqlTypeMappings.put(Byte.TYPE, -6);
        sqlTypeMappings.put(Short.class, 5);
        sqlTypeMappings.put(Short.TYPE, 5);
        sqlTypeMappings.put(Integer.class, 4);
        sqlTypeMappings.put(Integer.TYPE, 4);
        sqlTypeMappings.put(Long.class, -5);
        sqlTypeMappings.put(Long.TYPE, -5);
        sqlTypeMappings.put(Double.class, 8);
        sqlTypeMappings.put(Double.TYPE, 8);
        sqlTypeMappings.put(Float.class, 7);
        sqlTypeMappings.put(Float.TYPE, 7);
        sqlTypeMappings.put(Boolean.class, -7);
        sqlTypeMappings.put(Boolean.TYPE, -7);
        sqlTypeMappings.put(byte[].class, -3);
        sqlTypeMappings.put(Date.class, 91);
        sqlTypeMappings.put(Time.class, 92);
        sqlTypeMappings.put(Timestamp.class, 93);
    }
}

