/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jdbc.repository.support.JdbcQueryMethod;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.event.AfterLoadCallback;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class JdbcRepositoryQuery
implements RepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final ApplicationEventPublisher publisher;
    private final EntityCallbacks callbacks;
    private final RelationalMappingContext context;
    private final JdbcQueryMethod queryMethod;
    private final NamedParameterJdbcOperations operations;
    private final QueryExecutor<Object> executor;

    JdbcRepositoryQuery(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, RowMapper<?> defaultRowMapper) {
        Assert.notNull((Object)publisher, (String)"Publisher must not be null!");
        Assert.notNull((Object)context, (String)"Context must not be null!");
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null!");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null!");
        if (!queryMethod.isModifyingQuery()) {
            Assert.notNull(defaultRowMapper, (String)"Mapper must not be null!");
        }
        this.publisher = publisher;
        this.callbacks = callbacks == null ? EntityCallbacks.create() : callbacks;
        this.context = context;
        this.queryMethod = queryMethod;
        this.operations = operations;
        RowMapper rowMapper = this.determineRowMapper(defaultRowMapper);
        this.executor = this.createExecutor(queryMethod, this.determineResultSetExtractor((RowMapper<?>)(rowMapper != defaultRowMapper ? rowMapper : null)), rowMapper);
    }

    private QueryExecutor<Object> createExecutor(JdbcQueryMethod queryMethod, @Nullable ResultSetExtractor extractor, RowMapper rowMapper) {
        String query = this.determineQuery();
        if (queryMethod.isModifyingQuery()) {
            return this.createModifyingQueryExecutor(query);
        }
        if (queryMethod.isCollectionQuery() || queryMethod.isStreamQuery()) {
            QueryExecutor<Object> innerExecutor = extractor != null ? this.createResultSetExtractorQueryExecutor(query, extractor) : this.createListRowMapperQueryExecutor(query, rowMapper);
            return this.createCollectionQueryExecutor(innerExecutor);
        }
        QueryExecutor<Object> innerExecutor = extractor != null ? this.createResultSetExtractorQueryExecutor(query, extractor) : this.createObjectRowMapperQueryExecutor(query, rowMapper);
        return this.createObjectQueryExecutor(innerExecutor);
    }

    public Object execute(Object[] objects) {
        return this.executor.execute(this.bindParameters(objects));
    }

    private QueryExecutor<Object> createObjectQueryExecutor(QueryExecutor executor) {
        return parameters -> {
            try {
                Object result = executor.execute(parameters);
                this.publishAfterLoad(result);
                return result;
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        };
    }

    private QueryExecutor<Object> createCollectionQueryExecutor(QueryExecutor<Object> executor) {
        return parameters -> {
            List result = (List)executor.execute(parameters);
            Assert.notNull((Object)result, (String)"A collection valued result must never be null.");
            this.publishAfterLoad((Object)result);
            return result;
        };
    }

    private QueryExecutor<Object> createModifyingQueryExecutor(String query) {
        return parameters -> {
            int updatedCount = this.operations.update(query, (SqlParameterSource)parameters);
            Class returnedObjectType = this.queryMethod.getReturnedObjectType();
            return returnedObjectType == Boolean.TYPE || returnedObjectType == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(updatedCount != 0) : (Comparable<Boolean>)Integer.valueOf(updatedCount);
        };
    }

    private QueryExecutor<Object> createListRowMapperQueryExecutor(String query, RowMapper<?> rowMapper) {
        return parameters -> this.operations.query(query, (SqlParameterSource)parameters, rowMapper);
    }

    private QueryExecutor<Object> createObjectRowMapperQueryExecutor(String query, RowMapper<?> rowMapper) {
        return parameters -> this.operations.queryForObject(query, (SqlParameterSource)parameters, rowMapper);
    }

    private QueryExecutor<Object> createResultSetExtractorQueryExecutor(String query, ResultSetExtractor<?> resultSetExtractor) {
        return parameters -> this.operations.query(query, (SqlParameterSource)parameters, resultSetExtractor);
    }

    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private String determineQuery() {
        String query = this.queryMethod.getAnnotatedQuery();
        if (StringUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.queryMethod.getName()));
        }
        return query;
    }

    private MapSqlParameterSource bindParameters(Object[] objects) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        this.queryMethod.getParameters().getBindableParameters().forEach(p -> {
            String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            parameters.addValue(parameterName, objects[p.getIndex()]);
        });
        return parameters;
    }

    @Nullable
    private ResultSetExtractor determineResultSetExtractor(@Nullable RowMapper<?> rowMapper) {
        Class<? extends ResultSetExtractor> resultSetExtractorClass = this.queryMethod.getResultSetExtractorClass();
        if (JdbcRepositoryQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
            return null;
        }
        Constructor constructor = ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class});
        if (constructor != null) {
            return (ResultSetExtractor)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{rowMapper});
        }
        return (ResultSetExtractor)BeanUtils.instantiateClass(resultSetExtractorClass);
    }

    private RowMapper determineRowMapper(RowMapper<?> defaultMapper) {
        Class<? extends RowMapper> rowMapperClass = this.queryMethod.getRowMapperClass();
        if (JdbcRepositoryQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
            return defaultMapper;
        }
        return (RowMapper)BeanUtils.instantiateClass(rowMapperClass);
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }

    private <T> void publishAfterLoad(Iterable<T> all) {
        for (T e : all) {
            this.publishAfterLoad(e);
        }
    }

    private <T> void publishAfterLoad(@Nullable T entity) {
        if (entity != null && this.context.hasPersistentEntityFor(entity.getClass())) {
            RelationalPersistentEntity e = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(entity.getClass());
            Object identifier = e.getIdentifierAccessor(entity).getIdentifier();
            if (identifier != null) {
                this.publisher.publishEvent((ApplicationEvent)new AfterLoadEvent(Identifier.of((Object)identifier), entity));
            }
            this.callbacks.callback(AfterLoadCallback.class, entity, new Object[0]);
        }
    }

    private static interface QueryExecutor<T> {
        @Nullable
        public T execute(MapSqlParameterSource var1);
    }
}

