/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.lang.reflect.Constructor;
import java.sql.JDBCType;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.Parameter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class StringBasedJdbcQuery
extends AbstractJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final JdbcQueryMethod queryMethod;
    private final JdbcQueryExecution<?> executor;
    private final JdbcConverter converter;

    public StringBasedJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter) {
        super(queryMethod, operations, defaultRowMapper);
        this.queryMethod = queryMethod;
        this.converter = converter;
        RowMapper<Object> rowMapper = this.determineRowMapper(defaultRowMapper);
        this.executor = this.getQueryExecution(queryMethod, this.determineResultSetExtractor((RowMapper<Object>)(rowMapper != defaultRowMapper ? rowMapper : null)), rowMapper);
    }

    public Object execute(Object[] objects) {
        return this.executor.execute(this.determineQuery(), (SqlParameterSource)this.bindParameters(objects));
    }

    @Override
    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    MapSqlParameterSource bindParameters(Object[] objects) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ((RelationalParameters)this.queryMethod.getParameters().getBindableParameters()).forEach(p -> this.convertAndAddParameter(parameters, (Parameter)p, objects[p.getIndex()]));
        return parameters;
    }

    private void convertAndAddParameter(MapSqlParameterSource parameters, Parameter p, Object value) {
        String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
        Class parameterType = ((RelationalParameters.RelationalParameter)this.queryMethod.getParameters().getParameter(p.getIndex())).getType();
        Class<?> conversionTargetType = JdbcColumnTypes.INSTANCE.resolvePrimitiveType(parameterType);
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, conversionTargetType, JdbcUtil.sqlTypeFor(conversionTargetType));
        JDBCType jdbcType = jdbcValue.getJdbcType();
        if (jdbcType == null) {
            parameters.addValue(parameterName, jdbcValue.getValue());
        } else {
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
    }

    private String determineQuery() {
        String query = this.queryMethod.getDeclaredQuery();
        if (StringUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.queryMethod.getName()));
        }
        return query;
    }

    @Nullable
    ResultSetExtractor<Object> determineResultSetExtractor(@Nullable RowMapper<Object> rowMapper) {
        Class<? extends ResultSetExtractor> resultSetExtractorClass = this.queryMethod.getResultSetExtractorClass();
        if (StringBasedJdbcQuery.isUnconfigured(resultSetExtractorClass, ResultSetExtractor.class)) {
            return null;
        }
        Constructor constructor = ClassUtils.getConstructorIfAvailable(resultSetExtractorClass, (Class[])new Class[]{RowMapper.class});
        if (constructor != null) {
            return (ResultSetExtractor)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{rowMapper});
        }
        return (ResultSetExtractor)BeanUtils.instantiateClass(resultSetExtractorClass);
    }

    RowMapper<Object> determineRowMapper(@Nullable RowMapper<?> defaultMapper) {
        Class<? extends RowMapper> rowMapperClass = this.queryMethod.getRowMapperClass();
        if (StringBasedJdbcQuery.isUnconfigured(rowMapperClass, RowMapper.class)) {
            return defaultMapper;
        }
        return (RowMapper)BeanUtils.instantiateClass(rowMapperClass);
    }

    private static boolean isUnconfigured(@Nullable Class<?> configuredClass, Class<?> defaultClass) {
        return configuredClass == null || configuredClass == defaultClass;
    }
}

