/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.PartTreeJdbcQuery;
import org.springframework.data.jdbc.repository.query.StringBasedJdbcQuery;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.event.AfterLoadCallback;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JdbcQueryLookupStrategy
implements QueryLookupStrategy {
    private final ApplicationEventPublisher publisher;
    @Nullable
    private final EntityCallbacks callbacks;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final NamedParameterJdbcOperations operations;
    private final BeanFactory beanfactory;

    JdbcQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, BeanFactory beanfactory) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContextPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.publisher = publisher;
        this.callbacks = callbacks;
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.operations = operations;
        this.beanfactory = beanfactory;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        JdbcQueryMethod queryMethod = new JdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.context);
        try {
            if (namedQueries.hasQuery(queryMethod.getNamedQueryName()) || queryMethod.hasAnnotatedQuery()) {
                RowMapper<Object> mapper = queryMethod.isModifyingQuery() ? null : this.createMapper(queryMethod);
                StringBasedJdbcQuery query = new StringBasedJdbcQuery(queryMethod, this.operations, mapper, this.converter);
                query.setBeanFactory(this.beanfactory);
                return query;
            }
            return new PartTreeJdbcQuery(this.context, queryMethod, this.dialect, this.converter, this.operations, this.createMapper(queryMethod));
        }
        catch (Exception e) {
            throw QueryCreationException.create((QueryMethod)queryMethod, (Throwable)e);
        }
    }

    private RowMapper<Object> createMapper(JdbcQueryMethod queryMethod) {
        Class returnedObjectType = queryMethod.getReturnedObjectType();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance((Class)returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultMapper(queryMethod);
    }

    private RowMapper<?> determineDefaultMapper(JdbcQueryMethod queryMethod) {
        Class domainType = queryMethod.getReturnedObjectType();
        RowMapper configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(domainType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        EntityRowMapper defaultEntityRowMapper = new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType), this.converter);
        return new PostProcessingRowMapper(defaultEntityRowMapper);
    }

    class PostProcessingRowMapper<T>
    implements RowMapper<T> {
        private final RowMapper<T> delegate;

        PostProcessingRowMapper(RowMapper<T> delegate) {
            this.delegate = delegate;
        }

        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            Object entity = this.delegate.mapRow(rs, rowNum);
            if (entity != null) {
                JdbcQueryLookupStrategy.this.publisher.publishEvent((ApplicationEvent)new AfterLoadEvent(entity));
                if (JdbcQueryLookupStrategy.this.callbacks != null) {
                    return (T)JdbcQueryLookupStrategy.this.callbacks.callback(AfterLoadCallback.class, entity, new Object[0]);
                }
            }
            return (T)entity;
        }
    }
}

