/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import org.h2.api.TimestampWithTimeZone;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.relational.core.dialect.H2Dialect;

public class JdbcH2Dialect
extends H2Dialect {
    public static JdbcH2Dialect INSTANCE = new JdbcH2Dialect();

    protected JdbcH2Dialect() {
    }

    public Collection<Object> getConverters() {
        ArrayList<Object> converters = new ArrayList<Object>(super.getConverters());
        converters.add((Object)TimestampWithTimeZoneToOffsetDateTimeConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    static enum TimestampWithTimeZoneToOffsetDateTimeConverter implements Converter<TimestampWithTimeZone, OffsetDateTime>
    {
        INSTANCE;


        public OffsetDateTime convert(TimestampWithTimeZone source) {
            long nanosInSecond = 1000000000L;
            long nanosInMinute = nanosInSecond * 60L;
            long nanosInHour = nanosInMinute * 60L;
            long hours = source.getNanosSinceMidnight() / nanosInHour;
            long nanosInHours = hours * nanosInHour;
            long nanosLeft = source.getNanosSinceMidnight() - nanosInHours;
            long minutes = nanosLeft / nanosInMinute;
            long nanosInMinutes = minutes * nanosInMinute;
            long seconds = (nanosLeft -= nanosInMinutes) / nanosInSecond;
            long nanosInSeconds = seconds * nanosInSecond;
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(source.getTimeZoneOffsetSeconds());
            return OffsetDateTime.of(source.getYear(), source.getMonth(), source.getDay(), (int)hours, (int)minutes, (int)seconds, (int)(nanosLeft -= nanosInSeconds), offset);
        }
    }
}

