/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.RowMapper;

public class EntityRowMapper<T>
implements RowMapper<T> {
    private final RelationalPersistentEntity<T> entity;
    private final PersistentPropertyPathExtension path;
    private final JdbcConverter converter;
    private final Identifier identifier;

    public EntityRowMapper(PersistentPropertyPathExtension path, JdbcConverter converter, Identifier identifier) {
        this.entity = path.getLeafEntity();
        this.path = path;
        this.converter = converter;
        this.identifier = identifier;
    }

    public EntityRowMapper(RelationalPersistentEntity<T> entity, JdbcConverter converter) {
        this.entity = entity;
        this.path = null;
        this.converter = converter;
        this.identifier = null;
    }

    public T mapRow(ResultSet resultSet, int rowNumber) {
        return this.path == null ? this.converter.mapRow(this.entity, resultSet, rowNumber) : this.converter.mapRow(this.path, resultSet, this.identifier, rowNumber);
    }
}

