/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.jdbc.core.convert.BatchInsertStrategy;
import org.springframework.data.jdbc.core.convert.BatchJdbcOperations;
import org.springframework.data.jdbc.core.convert.InsertStrategy;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;

class IdGeneratingBatchInsertStrategy
implements BatchInsertStrategy {
    private final InsertStrategy insertStrategy;
    private final Dialect dialect;
    private final BatchJdbcOperations batchJdbcOperations;
    private final SqlIdentifier idColumn;

    IdGeneratingBatchInsertStrategy(InsertStrategy insertStrategy, Dialect dialect, BatchJdbcOperations batchJdbcOperations, @Nullable SqlIdentifier idColumn) {
        this.insertStrategy = insertStrategy;
        this.dialect = dialect;
        this.batchJdbcOperations = batchJdbcOperations;
        this.idColumn = idColumn;
    }

    @Override
    public Object[] execute(String sql, SqlParameterSource[] sqlParameterSources) {
        if (!this.dialect.getIdGeneration().supportedForBatchOperations()) {
            return Arrays.stream(sqlParameterSources).map(sqlParameterSource -> this.insertStrategy.execute(sql, (SqlParameterSource)sqlParameterSource)).toArray();
        }
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        IdGeneration idGeneration = this.dialect.getIdGeneration();
        if (idGeneration.driverRequiresKeyColumnNames()) {
            String[] keyColumnNames = this.getKeyColumnNames();
            if (keyColumnNames.length == 0) {
                this.batchJdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder);
            } else {
                this.batchJdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder, keyColumnNames);
            }
        } else {
            this.batchJdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder);
        }
        Object[] ids = new Object[sqlParameterSources.length];
        List keyList = holder.getKeyList();
        for (int i = 0; i < keyList.size(); ++i) {
            Map keys = (Map)keyList.get(i);
            if (keys.size() > 1) {
                if (this.idColumn == null) continue;
                ids[i] = keys.get(this.idColumn.getReference(this.dialect.getIdentifierProcessing()));
                continue;
            }
            ids[i] = keys.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalStateException("KeyHolder contains an empty key list"));
        }
        return ids;
    }

    private String[] getKeyColumnNames() {
        return Optional.ofNullable(this.idColumn).map(idColumn -> new String[]{idColumn.getReference(this.dialect.getIdentifierProcessing())}).orElse(new String[0]);
    }
}

