/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcIdentifierBuilder {
    private Identifier identifier;

    private JdbcIdentifierBuilder(Identifier identifier) {
        this.identifier = identifier;
    }

    public static JdbcIdentifierBuilder empty() {
        return new JdbcIdentifierBuilder(Identifier.empty());
    }

    @Deprecated(since="3.2", forRemoval=true)
    public static JdbcIdentifierBuilder forBackReferences(JdbcConverter converter, PersistentPropertyPathExtension path, @Nullable Object value) {
        return JdbcIdentifierBuilder.forBackReferences(converter, path.getAggregatePath(), value);
    }

    public static JdbcIdentifierBuilder forBackReferences(JdbcConverter converter, AggregatePath path, @Nullable Object value) {
        Identifier identifier = Identifier.of(path.getTableInfo().reverseColumnInfo().name(), value, converter.getColumnType(path.getIdDefiningParentPath().getRequiredIdProperty()));
        return new JdbcIdentifierBuilder(identifier);
    }

    @Deprecated
    public JdbcIdentifierBuilder withQualifier(PersistentPropertyPathExtension path, Object value) {
        return this.withQualifier(path.getAggregatePath(), value);
    }

    public JdbcIdentifierBuilder withQualifier(AggregatePath path, Object value) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.identifier = this.identifier.withPart(path.getTableInfo().qualifierColumnInfo().name(), value, path.getTableInfo().qualifierColumnType());
        return this;
    }

    public Identifier build() {
        return this.identifier;
    }
}

