/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import java.net.URL;
import javax.persistence.spi.PersistenceUnitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;

public class MergingPersistenceUnitManager
extends DefaultPersistenceUnitManager {
    private static final Logger log = LoggerFactory.getLogger(MergingPersistenceUnitManager.class);

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        super.postProcessPersistenceUnitInfo(pui);
        MutablePersistenceUnitInfo oldPui = this.getPersistenceUnitInfo(pui.getPersistenceUnitName());
        if (oldPui != null) {
            this.postProcessPersistenceUnitInfo(pui, (PersistenceUnitInfo)oldPui);
        }
    }

    protected boolean isPersistenceUnitOverrideAllowed() {
        return true;
    }

    void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui, PersistenceUnitInfo oldPui) {
        for (URL url : oldPui.getJarFileUrls()) {
            if (pui.getJarFileUrls().contains(url)) continue;
            log.debug("Adding {} to persistence units", (Object)url);
            pui.addJarFileUrl(url);
        }
        for (String className : oldPui.getManagedClassNames()) {
            if (pui.getManagedClassNames().contains(className)) continue;
            log.debug("Adding class {} to PersistenceUnit {}", (Object)className, (Object)pui.getPersistenceUnitName());
            pui.addManagedClassName(className);
        }
        pui.addJarFileUrl(oldPui.getPersistenceUnitRootUrl());
    }
}

