/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Iterator;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CriteriaQueryParameterBinder
extends ParameterBinder {
    private final Iterator<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

    CriteriaQueryParameterBinder(Parameters parameters, Object[] values, Iterable<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
        super(parameters, values);
        Assert.notNull(expressions);
        this.expressions = expressions.iterator();
    }

    @Override
    protected void bind(Query query, Parameter parameter, Object value, int position) {
        ParameterMetadataProvider.ParameterMetadata<?> metadata = this.expressions.next();
        if (metadata.isIsNullParameter()) {
            return;
        }
        query.setParameter(metadata.getExpression(), metadata.prepare(value));
    }
}

