/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.data.jpa.repository.support.QuerydslUtils;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDslJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityManager em;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;
    private final PersistenceProvider provider;

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        this(entityInformation, entityManager, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        super(entityInformation, entityManager);
        this.em = entityManager;
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQuery(predicate).uniqueResult(this.path);
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQuery(predicate).list(this.path);
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return ((JPQLQuery)this.createQuery(predicate).orderBy(orders)).list(this.path);
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        JPQLQuery countQuery = this.createQuery(predicate);
        JPQLQuery query = this.applyPagination(this.createQuery(predicate), pageable);
        return new PageImpl(query.list(this.path), pageable, countQuery.count());
    }

    public long count(Predicate predicate) {
        return this.createQuery(predicate).count();
    }

    protected JPQLQuery createQuery(Predicate ... predicate) {
        return (JPQLQuery)((JPQLQuery)QuerydslUtils.createQueryInstance(this.em, this.provider).from(new EntityPath[]{this.path})).where(predicate);
    }

    protected JPQLQuery applyPagination(JPQLQuery query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    protected JPQLQuery applySorting(JPQLQuery query, Sort sort) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order)});
        }
        return query;
    }

    protected OrderSpecifier<?> toOrder(Sort.Order order) {
        PathBuilder property = this.builder.get(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, (Expression)property);
    }
}

