/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderFactory;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAUpdateClause;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public abstract class QueryDslRepositorySupport {
    private final PathBuilder<?> builder;
    private EntityManager entityManager;
    private Querydsl querydsl;

    public QueryDslRepositorySupport(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        this.builder = new PathBuilderFactory().create(domainClass);
    }

    public void setEntityManager(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null!");
        this.querydsl = new Querydsl(entityManager, this.builder);
        this.entityManager = entityManager;
    }

    @PostConstruct
    public void validate() {
        Assert.notNull((Object)this.entityManager, (String)"EntityManager must not be null!");
        Assert.notNull((Object)this.querydsl, (String)"Querydsl must not be null!");
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected JPQLQuery<Object> from(EntityPath<?> ... paths) {
        return this.querydsl.createQuery(paths);
    }

    protected <T> JPQLQuery<T> from(EntityPath<T> path) {
        return this.querydsl.createQuery(path).select(path);
    }

    protected DeleteClause<JPADeleteClause> delete(EntityPath<?> path) {
        return new JPADeleteClause(this.entityManager, path);
    }

    protected UpdateClause<JPAUpdateClause> update(EntityPath<?> path) {
        return new JPAUpdateClause(this.entityManager, path);
    }

    protected <T> PathBuilder<T> getBuilder() {
        return this.builder;
    }

    protected Querydsl getQuerydsl() {
        return this.querydsl;
    }
}

