/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.query.StringQueryParameterBinder;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

final class SimpleJpaQuery
extends AbstractJpaQuery {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJpaQuery.class);
    private final StringQuery query;
    private final StringQuery countQuery;
    private final JpaQueryMethod method;

    SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        boolean hasPagingOrSortingParameter;
        this.method = method;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation());
        JpaParameters parameters = method.getParameters();
        boolean bl = hasPagingOrSortingParameter = parameters.hasPageableParameter() || parameters.hasSortParameter();
        if (method.isNativeQuery() && hasPagingOrSortingParameter) {
            throw new IllegalStateException("Cannot use native queries with dynamic sorting and/or pagination!");
        }
        String preparedQueryString = this.query.getQueryString();
        if (!method.isNativeQuery()) {
            this.validateQuery(preparedQueryString, em, String.format("Validation failed for query for method %s!", new Object[]{method}));
        }
        this.countQuery = new StringQuery(method.getCountQuery() != null ? method.getCountQuery() : QueryUtils.createCountQueryFor(preparedQueryString));
        if (!method.isNativeQuery() && method.isPageQuery()) {
            this.validateQuery(this.countQuery.getQueryString(), em, String.format("Count query validation failed for method %s!", new Object[]{method}));
        }
    }

    private final void validateQuery(String query, EntityManager em, String errorMessage) {
        EntityManager validatingEm = null;
        try {
            validatingEm = em.getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
        finally {
            if (validatingEm != null) {
                validatingEm.close();
            }
        }
    }

    SimpleJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, method.getAnnotatedQuery());
    }

    @Override
    protected ParameterBinder createBinder(Object[] values) {
        return new StringQueryParameterBinder(this.getQueryMethod().getParameters(), values, this.query);
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.method.getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        EntityManager em = this.getEntityManager();
        Query query = null;
        query = this.method.isNativeQuery() ? (this.method.isQueryForEntity() ? em.createNativeQuery(sortedQueryString, this.method.getReturnedObjectType()) : em.createNativeQuery(sortedQueryString)) : em.createQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(query);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return this.createBinder(values).bind(this.getEntityManager().createQuery(this.countQuery.getQueryString(), Long.class));
    }

    public static RepositoryQuery fromQueryAnnotation(JpaQueryMethod queryMethod, EntityManager em) {
        LOG.debug("Looking up query for method {}", (Object)queryMethod.getName());
        String query = queryMethod.getAnnotatedQuery();
        return query == null ? null : new SimpleJpaQuery(queryMethod, em, query);
    }
}

