/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.query.StringQueryParameterBinder;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final StringQuery query;
    private final StringQuery countQuery;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        Assert.hasText((String)queryString, (String)"Query string must not be null or empty!");
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation());
        this.countQuery = new StringQuery(method.getCountQuery() != null ? method.getCountQuery() : QueryUtils.createCountQueryFor(this.query.getQueryString()));
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        Query query = this.createJpaQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(query);
    }

    @Override
    protected ParameterBinder createBinder(Object[] values) {
        return new StringQueryParameterBinder(this.getQueryMethod().getParameters(), values, this.query);
    }

    public Query createJpaQuery(String queryString) {
        return this.getEntityManager().createQuery(queryString);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return this.createBinder(values).bind(this.getEntityManager().createQuery(this.countQuery.getQueryString(), Long.class));
    }

    public StringQuery getQuery() {
        return this.query;
    }

    public StringQuery getCountQuery() {
        return this.countQuery;
    }
}

