/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;

final class NativeJpaQuery
extends AbstractStringBasedJpaQuery {
    public NativeJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em, queryString);
        boolean hasPagingOrSortingParameter;
        JpaParameters parameters = method.getParameters();
        boolean bl = hasPagingOrSortingParameter = parameters.hasPageableParameter() || parameters.hasSortParameter();
        if (hasPagingOrSortingParameter) {
            throw new InvalidJpaQueryMethodException("Cannot use native queries with dynamic sorting and/or pagination in method " + (Object)((Object)method));
        }
    }

    @Override
    public Query createJpaQuery(String queryString) {
        return this.getQueryMethod().isQueryForEntity() ? this.getEntityManager().createNativeQuery(queryString, this.getQueryMethod().getReturnedObjectType()) : this.getEntityManager().createNativeQuery(queryString);
    }
}

