/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

public class JpaCountQueryCreator
extends JpaQueryCreator {
    public JpaCountQueryCreator(PartTree tree, ReturnedType type, CriteriaBuilder builder, ParameterMetadataProvider provider) {
        super(tree, type, builder, provider);
    }

    @Override
    protected CriteriaQuery<? extends Object> createCriteriaQuery(CriteriaBuilder builder, ReturnedType type) {
        return builder.createQuery(type.getDomainType());
    }

    @Override
    protected CriteriaQuery<? extends Object> complete(@Nullable Predicate predicate, Sort sort, CriteriaQuery<? extends Object> query, CriteriaBuilder builder, Root<?> root) {
        CriteriaQuery select = query.select((Selection)JpaCountQueryCreator.getCountQuery(query, builder, root));
        return predicate == null ? select : select.where((Expression)predicate);
    }

    private static Expression getCountQuery(CriteriaQuery<?> query, CriteriaBuilder builder, Root<?> root) {
        return query.isDistinct() ? builder.countDistinct(root) : builder.count(root);
    }
}

