/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.InvalidJpaQueryMethodException;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

final class NativeJpaQuery
extends AbstractStringBasedJpaQuery {
    public NativeJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryRewriter rewriter, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em, queryString, countQueryString, rewriter, evaluationContextProvider, parser);
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter() && !queryString.contains("#sort")) {
            throw new InvalidJpaQueryMethodException("Cannot use native queries with dynamic sorting in method " + method);
        }
    }

    @Override
    protected Query createJpaQuery(String queryString, Sort sort, Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        Class<?> type = this.getTypeToQueryFor(returnedType);
        return type == null ? em.createNativeQuery(this.potentiallyRewriteQuery(queryString, sort, pageable)) : em.createNativeQuery(this.potentiallyRewriteQuery(queryString, sort, pageable), type);
    }

    @Nullable
    private Class<?> getTypeToQueryFor(ReturnedType returnedType) {
        Class<Tuple> result;
        Class<Tuple> clazz = result = this.getQueryMethod().isQueryForEntity() ? returnedType.getDomainType() : null;
        if (this.getQuery().hasConstructorExpression() || this.getQuery().isDefaultProjection()) {
            return result;
        }
        return returnedType.isProjecting() && !this.getMetamodel().isJpaManaged(returnedType.getReturnedType()) ? Tuple.class : result;
    }
}

