/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method; Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider";
    private static final Log LOG = LogFactory.getLog(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    @Nullable
    private final String countProjection;
    private final boolean namedCountQueryIsPresent;
    private final DeclaredQuery declaredQuery;
    private final QueryParameterSetter.QueryMetadataCache metadataCache;

    private NamedQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        QueryExtractor extractor = method.getQueryExtractor();
        this.countProjection = method.getCountQueryProjection();
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query; Use @Query instead", new Object[]{method}));
        }
        this.namedCountQueryIsPresent = NamedQuery.hasNamedQuery(em, this.countQueryName);
        Query query = em.createNamedQuery(this.queryName);
        String queryString = extractor.extractQueryString(query);
        this.declaredQuery = DeclaredQuery.of(queryString, false);
        boolean weNeedToCreateCountQuery = !this.namedCountQueryIsPresent && method.getParameters().hasLimitingParameters();
        boolean bl = cantExtractQuery = !extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, (String)CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn((Object)String.format("Finder method %s is backed by a NamedQuery but contains a Pageable parameter; Sorting delivered via this Pageable will not be applied", new Object[]{method}));
        }
        this.metadataCache = new QueryParameterSetter.QueryMetadataCache();
    }

    static boolean hasNamedQuery(EntityManager em, String queryName) {
        try (EntityManager lookupEm = em.getEntityManagerFactory().createEntityManager();){
            lookupEm.createNamedQuery(queryName);
            return true;
        }
    }

    @Nullable
    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Looking up named query %s", queryName));
        }
        if (!NamedQuery.hasNamedQuery(em, queryName)) {
            return null;
        }
        if (method.isScrollQuery()) {
            throw QueryCreationException.create((QueryMethod)method, (String)"Scroll queries are not supported using String-based queries");
        }
        NamedQuery query = new NamedQuery(method, em);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Found named query %s", queryName));
        }
        return query;
    }

    @Override
    protected Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        EntityManager em = this.getEntityManager();
        JpaQueryMethod queryMethod = this.getQueryMethod();
        ResultProcessor processor = queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class<?> typeToRead = this.getTypeToRead(processor.getReturnedType());
        Query query = typeToRead == null ? em.createNamedQuery(this.queryName) : em.createNamedQuery(this.queryName, typeToRead);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(this.queryName, query);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, metadata, accessor);
    }

    protected TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        TypedQuery countQuery;
        String cacheKey;
        EntityManager em = this.getEntityManager();
        if (this.namedCountQueryIsPresent) {
            cacheKey = this.countQueryName;
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            String countQueryString;
            cacheKey = countQueryString = this.declaredQuery.deriveCountQuery(this.countProjection).getQueryString();
            countQuery = em.createQuery(countQueryString, Long.class);
        }
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(cacheKey, (Query)countQuery);
        return ((ParameterBinder)this.parameterBinder.get()).bind(countQuery, metadata, accessor);
    }

    @Override
    protected Class<?> getTypeToRead(ReturnedType returnedType) {
        if (this.getQueryMethod().isNativeQuery()) {
            Class type = returnedType.getReturnedType();
            Class domainType = returnedType.getDomainType();
            if (domainType.isAssignableFrom(type)) {
                return type;
            }
            if (type.isAssignableFrom(domainType)) {
                return domainType;
            }
            return type.isInterface() ? Tuple.class : null;
        }
        return this.declaredQuery.hasConstructorExpression() ? null : super.getTypeToRead(returnedType);
    }
}

