/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.EqlBaseVisitor;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;

class EqlQueryRenderer
extends EqlBaseVisitor<List<JpaQueryParsingToken>> {
    EqlQueryRenderer() {
    }

    @Override
    public List<JpaQueryParsingToken> visitStart(EqlParser.StartContext ctx) {
        return (List)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public List<JpaQueryParsingToken> visitQl_statement(EqlParser.Ql_statementContext ctx) {
        if (ctx.select_statement() != null) {
            return (List)this.visit((ParseTree)ctx.select_statement());
        }
        if (ctx.update_statement() != null) {
            return (List)this.visit((ParseTree)ctx.update_statement());
        }
        if (ctx.delete_statement() != null) {
            return (List)this.visit((ParseTree)ctx.delete_statement());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_statement(EqlParser.Select_statementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.select_clause()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.orderby_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.orderby_clause()));
        }
        int i = 0;
        while (i < ctx.setOperator().size()) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.setOperator(i)));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.select_statement(i)));
            ++i;
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSetOperator(EqlParser.SetOperatorContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.UNION() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.UNION()));
        } else if (ctx.INTERSECT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INTERSECT()));
        } else if (ctx.EXCEPT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXCEPT()));
        }
        if (ctx.ALL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ALL()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUpdate_statement(EqlParser.Update_statementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.update_clause()));
        if (ctx.where_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.where_clause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDelete_statement(EqlParser.Delete_statementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.delete_clause()));
        if (ctx.where_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.where_clause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFrom_clause(EqlParser.From_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.FROM(), true));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable_declaration()));
        ctx.identificationVariableDeclarationOrCollectionMemberDeclaration().forEach(identificationVariableDeclarationOrCollectionMemberDeclarationContext -> {
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)identificationVariableDeclarationOrCollectionMemberDeclarationContext));
        });
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(EqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx) {
        if (ctx.identification_variable_declaration() != null) {
            return (List)this.visit((ParseTree)ctx.identification_variable_declaration());
        }
        if (ctx.collection_member_declaration() != null) {
            return (List)this.visit((ParseTree)ctx.collection_member_declaration());
        }
        if (ctx.subquery() != null) {
            ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            return tokens;
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitIdentification_variable_declaration(EqlParser.Identification_variable_declarationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.range_variable_declaration()));
        ctx.join().forEach(joinContext -> tokens.addAll((Collection)this.visit((ParseTree)joinContext)));
        ctx.fetch_join().forEach(fetchJoinContext -> tokens.addAll((Collection)this.visit((ParseTree)fetchJoinContext)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.entity_name() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_name()));
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        }
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin(EqlParser.JoinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.join_spec()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.join_association_path_expression()));
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        if (ctx.join_condition() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.join_condition()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFetch_join(EqlParser.Fetch_joinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.join_spec()));
        tokens.add(new JpaQueryParsingToken(ctx.FETCH()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.join_association_path_expression()));
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        if (ctx.join_condition() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.join_condition()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin_spec(EqlParser.Join_specContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.LEFT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LEFT()));
        }
        if (ctx.OUTER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.OUTER()));
        }
        if (ctx.INNER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INNER()));
        }
        if (ctx.JOIN() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.JOIN()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin_condition(EqlParser.Join_conditionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.ON()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin_association_path_expression(EqlParser.Join_association_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.TREAT() == null) {
            if (ctx.join_collection_valued_path_expression() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            }
        } else if (ctx.join_collection_valued_path_expression() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TREAT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subtype()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.join_single_valued_path_expression() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TREAT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subtype()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin_collection_valued_path_expression(EqlParser.Join_collection_valued_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        }
        ctx.single_valued_embeddable_object_field().forEach(singleValuedEmbeddableObjectFieldContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)singleValuedEmbeddableObjectFieldContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_field()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin_single_valued_path_expression(EqlParser.Join_single_valued_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        }
        ctx.single_valued_embeddable_object_field().forEach(singleValuedEmbeddableObjectFieldContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)singleValuedEmbeddableObjectFieldContext));
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_field()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_member_declaration(EqlParser.Collection_member_declarationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.IN(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitQualified_identification_variable(EqlParser.Qualified_identification_variableContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.map_field_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.map_field_identification_variable()));
        } else if (ctx.identification_variable() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ENTRY()));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitMap_field_identification_variable(EqlParser.Map_field_identification_variableContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.KEY() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.KEY(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.VALUE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.VALUE(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSingle_valued_path_expression(EqlParser.Single_valued_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.qualified_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.qualified_identification_variable()));
        } else if (ctx.qualified_identification_variable() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TREAT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.qualified_identification_variable()));
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subtype()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.state_field_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneral_identification_variable(EqlParser.General_identification_variableContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.map_field_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.map_field_identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneral_subpath(EqlParser.General_subpathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.simple_subpath() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_subpath()));
        } else if (ctx.treated_subpath() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.treated_subpath()));
            ctx.single_valued_object_field().forEach(singleValuedObjectFieldContext -> {
                tokens.add(JpaQueryParsingToken.TOKEN_DOT);
                tokens.addAll((Collection)this.visit((ParseTree)singleValuedObjectFieldContext));
            });
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_subpath(EqlParser.Simple_subpathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.general_identification_variable()));
        JpaQueryParsingToken.NOSPACE(tokens);
        ctx.single_valued_object_field().forEach(singleValuedObjectFieldContext -> {
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
            tokens.addAll((Collection)this.visit((ParseTree)singleValuedObjectFieldContext));
            JpaQueryParsingToken.NOSPACE(tokens);
        });
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTreated_subpath(EqlParser.Treated_subpathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.TREAT(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.general_subpath()));
        JpaQueryParsingToken.SPACE(tokens);
        tokens.add(new JpaQueryParsingToken(ctx.AS()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subtype()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitState_field_path_expression(EqlParser.State_field_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.general_subpath()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitState_valued_path_expression(EqlParser.State_valued_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_field_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.general_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.general_identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSingle_valued_object_path_expression(EqlParser.Single_valued_object_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.general_subpath()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_field()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_valued_path_expression(EqlParser.Collection_valued_path_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.general_subpath()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_value_field()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUpdate_clause(EqlParser.Update_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.UPDATE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.SET()));
        ctx.update_item().forEach(updateItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)updateItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUpdate_item(EqlParser.Update_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        }
        ctx.single_valued_embeddable_object_field().forEach(singleValuedEmbeddableObjectFieldContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)singleValuedEmbeddableObjectFieldContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        if (ctx.state_field() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field()));
        } else if (ctx.single_valued_object_field() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_field()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_EQUALS);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.new_value()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitNew_value(EqlParser.New_valueContext ctx) {
        if (ctx.scalar_expression() != null) {
            return (List)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.simple_entity_expression() != null) {
            return (List)this.visit((ParseTree)ctx.simple_entity_expression());
        }
        if (ctx.NULL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.NULL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitDelete_clause(EqlParser.Delete_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.DELETE()));
        tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_clause(EqlParser.Select_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        ctx.select_item().forEach(selectItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)selectItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_item(EqlParser.Select_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.select_expression()));
        JpaQueryParsingToken.SPACE(tokens);
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        if (ctx.result_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.result_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_expression(EqlParser.Select_expressionContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (List)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (List)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (List)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            if (ctx.OBJECT() == null) {
                return (List)this.visit((ParseTree)ctx.identification_variable());
            }
            ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
            tokens.add(new JpaQueryParsingToken(ctx.OBJECT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
            return tokens;
        }
        if (ctx.constructor_expression() != null) {
            return (List)this.visit((ParseTree)ctx.constructor_expression());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitConstructor_expression(EqlParser.Constructor_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.NEW()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.constructor_name()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        ctx.constructor_item().forEach(constructorItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)constructorItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConstructor_item(EqlParser.Constructor_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.scalar_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        } else if (ctx.aggregate_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAggregate_expression(EqlParser.Aggregate_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.AVG() != null || ctx.MAX() != null || ctx.MIN() != null || ctx.SUM() != null) {
            if (ctx.AVG() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.AVG(), false));
            }
            if (ctx.MAX() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.MAX(), false));
            }
            if (ctx.MIN() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.MIN(), false));
            }
            if (ctx.SUM() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.SUM(), false));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
            }
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.COUNT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.COUNT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
            }
            if (ctx.identification_variable() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            } else if (ctx.state_valued_path_expression() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
            } else if (ctx.single_valued_object_path_expression() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
            }
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWhere_clause(EqlParser.Where_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHERE(), true));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupby_clause(EqlParser.Groupby_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.GROUP()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        ctx.groupby_item().forEach(groupbyItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)groupbyItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupby_item(EqlParser.Groupby_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.scalar_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitHaving_clause(EqlParser.Having_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.HAVING()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOrderby_clause(EqlParser.Orderby_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.ORDER()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        ctx.orderby_item().forEach(orderbyItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)orderbyItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOrderby_item(EqlParser.Orderby_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_field_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.general_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.result_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.result_variable()));
        } else if (ctx.string_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression()));
        } else if (ctx.scalar_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        }
        if (ctx.ASC() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DESC()));
        }
        if (ctx.nullsPrecedence() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitNullsPrecedence(EqlParser.NullsPrecedenceContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_NULLS);
        if (ctx.FIRST() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_FIRST);
        } else if (ctx.LAST() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_LAST);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSubquery(EqlParser.SubqueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_select_clause()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery_from_clause()));
        if (ctx.where_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.having_clause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSubquery_from_clause(EqlParser.Subquery_from_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        ctx.subselect_identification_variable_declaration().forEach(subselectIdentificationVariableDeclarationContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)subselectIdentificationVariableDeclarationContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSubselect_identification_variable_declaration(EqlParser.Subselect_identification_variable_declarationContext ctx) {
        return (List)super.visitSubselect_identification_variable_declaration(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitDerived_path_expression(EqlParser.Derived_path_expressionContext ctx) {
        return (List)super.visitDerived_path_expression(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneral_derived_path(EqlParser.General_derived_pathContext ctx) {
        return (List)super.visitGeneral_derived_path(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_derived_path(EqlParser.Simple_derived_pathContext ctx) {
        return (List)super.visitSimple_derived_path(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitTreated_derived_path(EqlParser.Treated_derived_pathContext ctx) {
        return (List)super.visitTreated_derived_path(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitDerived_collection_member_declaration(EqlParser.Derived_collection_member_declarationContext ctx) {
        return (List)super.visitDerived_collection_member_declaration(ctx);
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_select_clause(EqlParser.Simple_select_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_select_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_select_expression(EqlParser.Simple_select_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.scalar_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        } else if (ctx.aggregate_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitScalar_expression(EqlParser.Scalar_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.arithmetic_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression()));
        } else if (ctx.string_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression()));
        } else if (ctx.enum_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.enum_expression()));
        } else if (ctx.datetime_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression()));
        } else if (ctx.boolean_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.boolean_expression()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.entity_type_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_type_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConditional_expression(EqlParser.Conditional_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.conditional_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
            tokens.add(new JpaQueryParsingToken(ctx.OR()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_term()));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_term()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConditional_term(EqlParser.Conditional_termContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.conditional_term() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_term()));
            tokens.add(new JpaQueryParsingToken(ctx.AND()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_factor()));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_factor()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConditional_factor(EqlParser.Conditional_factorContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        EqlParser.Conditional_primaryContext conditionalPrimary = ctx.conditional_primary();
        List visitedConditionalPrimary = (List)this.visit((ParseTree)conditionalPrimary);
        tokens.addAll(visitedConditionalPrimary);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConditional_primary(EqlParser.Conditional_primaryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.simple_cond_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_cond_expression()));
        } else if (ctx.conditional_expression() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_cond_expression(EqlParser.Simple_cond_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.comparison_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.comparison_expression()));
        } else if (ctx.between_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.between_expression()));
        } else if (ctx.in_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.in_expression()));
        } else if (ctx.like_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.like_expression()));
        } else if (ctx.null_comparison_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.null_comparison_expression()));
        } else if (ctx.empty_collection_comparison_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.empty_collection_comparison_expression()));
        } else if (ctx.collection_member_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_member_expression()));
        } else if (ctx.exists_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.exists_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitBetween_expression(EqlParser.Between_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.arithmetic_expression(0) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            if (ctx.NOT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.NOT()));
            }
            tokens.add(new JpaQueryParsingToken(ctx.BETWEEN()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            tokens.add(new JpaQueryParsingToken(ctx.AND()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(2)));
        } else if (ctx.string_expression(0) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            if (ctx.NOT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.NOT()));
            }
            tokens.add(new JpaQueryParsingToken(ctx.BETWEEN()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(1)));
            tokens.add(new JpaQueryParsingToken(ctx.AND()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(2)));
        } else if (ctx.datetime_expression(0) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression(0)));
            if (ctx.NOT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.NOT()));
            }
            tokens.add(new JpaQueryParsingToken(ctx.BETWEEN()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression(1)));
            tokens.add(new JpaQueryParsingToken(ctx.AND()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression(2)));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIn_expression(EqlParser.In_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        }
        if (ctx.type_discriminator() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.type_discriminator()));
        }
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        if (ctx.IN() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.IN()));
        }
        if (ctx.in_item() != null && !ctx.in_item().isEmpty()) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            ctx.in_item().forEach(inItemContext -> {
                tokens.addAll((Collection)this.visit((ParseTree)inItemContext));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.collection_valued_input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_input_parameter()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIn_item(EqlParser.In_itemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.literal()));
        } else if (ctx.single_valued_input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_input_parameter()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitLike_expression(EqlParser.Like_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.LIKE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.pattern_value()));
        if (ctx.ESCAPE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ESCAPE()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.escape_character()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitNull_comparison_expression(EqlParser.Null_comparison_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.nullif_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.nullif_expression()));
        }
        if (ctx.op != null) {
            tokens.add(new JpaQueryParsingToken(ctx.op.getText()));
        } else {
            tokens.add(new JpaQueryParsingToken(ctx.IS()));
            if (ctx.NOT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.NOT()));
            }
        }
        tokens.add(new JpaQueryParsingToken(ctx.NULL()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEmpty_collection_comparison_expression(EqlParser.Empty_collection_comparison_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        tokens.add(new JpaQueryParsingToken(ctx.IS()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.EMPTY()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_member_expression(EqlParser.Collection_member_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_or_value_expression()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.MEMBER()));
        if (ctx.OF() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.OF()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntity_or_value_expression(EqlParser.Entity_or_value_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_object_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.state_field_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.simple_entity_or_value_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_entity_or_value_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_entity_or_value_expression(EqlParser.Simple_entity_or_value_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.literal()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExists_expression(EqlParser.Exists_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.EXISTS()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAll_or_any_expression(EqlParser.All_or_any_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.ALL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ALL()));
        } else if (ctx.ANY() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ANY()));
        } else if (ctx.SOME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.SOME()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitStringComparison(EqlParser.StringComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.string_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitBooleanComparison(EqlParser.BooleanComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.boolean_expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        if (ctx.boolean_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.boolean_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDirectBooleanCheck(EqlParser.DirectBooleanCheckContext ctx) {
        return (List)this.visit((ParseTree)ctx.boolean_expression());
    }

    @Override
    public List<JpaQueryParsingToken> visitEnumComparison(EqlParser.EnumComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.enum_expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        if (ctx.enum_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.enum_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDatetimeComparison(EqlParser.DatetimeComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression(0)));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.datetime_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntityComparison(EqlParser.EntityComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        if (ctx.entity_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitArithmeticComparison(EqlParser.ArithmeticComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.arithmetic_expression(1) != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(1)));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntityTypeComparison(EqlParser.EntityTypeComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_type_expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_type_expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitRegexpComparison(EqlParser.RegexpComparisonContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression()));
        tokens.add(new JpaQueryParsingToken(ctx.REGEXP()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.string_literal()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitComparison_operator(EqlParser.Comparison_operatorContext ctx) {
        return List.of(new JpaQueryParsingToken(ctx.op));
    }

    @Override
    public List<JpaQueryParsingToken> visitArithmetic_expression(EqlParser.Arithmetic_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.arithmetic_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression()));
            tokens.add(new JpaQueryParsingToken(ctx.op));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_term()));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_term()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitArithmetic_term(EqlParser.Arithmetic_termContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.arithmetic_term() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_term()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(new JpaQueryParsingToken(ctx.op, false));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_factor()));
        } else {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_factor()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitArithmetic_factor(EqlParser.Arithmetic_factorContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.op != null) {
            tokens.add(new JpaQueryParsingToken(ctx.op, false));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_primary()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitArithmetic_primary(EqlParser.Arithmetic_primaryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.numeric_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.numeric_literal()));
        } else if (ctx.arithmetic_expression() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_numerics() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.functions_returning_numerics()));
        } else if (ctx.aggregate_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.cast_function() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.cast_function()));
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitString_expression(EqlParser.String_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.string_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_literal()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_strings() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.functions_returning_strings()));
        } else if (ctx.aggregate_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDatetime_expression(EqlParser.Datetime_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_datetime() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.functions_returning_datetime()));
        } else if (ctx.aggregate_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.date_time_timestamp_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.date_time_timestamp_literal()));
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitBoolean_expression(EqlParser.Boolean_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.boolean_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.boolean_literal()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEnum_expression(EqlParser.Enum_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.state_valued_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.enum_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.enum_literal()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntity_expression(EqlParser.Entity_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.single_valued_object_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.simple_entity_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simple_entity_expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_entity_expression(EqlParser.Simple_entity_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntity_type_expression(EqlParser.Entity_type_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.type_discriminator() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.type_discriminator()));
        } else if (ctx.entity_type_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_type_literal()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitType_discriminator(EqlParser.Type_discriminatorContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.TYPE(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.general_identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.input_parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.input_parameter()));
        }
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctions_returning_numerics(EqlParser.Functions_returning_numericsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.LENGTH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LENGTH(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOCATE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOCATE(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(1)));
            JpaQueryParsingToken.NOSPACE(tokens);
            if (ctx.arithmetic_expression() != null) {
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
                tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
                JpaQueryParsingToken.NOSPACE(tokens);
            }
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.ABS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ABS(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.CEILING() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CEILING(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.EXP() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXP(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.FLOOR() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FLOOR(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.LN() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LN(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIGN() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.SIGN(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.SQRT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.SQRT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.MOD() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.MOD(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.POWER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.POWER(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.ROUND() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROUND(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIZE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.SIZE(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.collection_valued_path_expression()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.INDEX() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INDEX(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.extract_datetime_field() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.extract_datetime_field()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctions_returning_datetime(EqlParser.Functions_returning_datetimeContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.CURRENT_DATE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_DATE()));
        } else if (ctx.CURRENT_TIME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_TIME()));
        } else if (ctx.CURRENT_TIMESTAMP() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_TIMESTAMP()));
        } else if (ctx.LOCAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOCAL()));
            if (ctx.DATE() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DATE()));
            } else if (ctx.TIME() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.TIME()));
            } else if (ctx.DATETIME() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DATETIME()));
            }
        } else if (ctx.extract_datetime_part() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.extract_datetime_part()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctions_returning_strings(EqlParser.Functions_returning_stringsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.CONCAT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CONCAT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            ctx.string_expression().forEach(stringExpressionContext -> {
                tokens.addAll((Collection)this.visit((ParseTree)stringExpressionContext));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.SUBSTRING() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.SUBSTRING(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            ctx.arithmetic_expression().forEach(arithmeticExpressionContext -> {
                tokens.addAll((Collection)this.visit((ParseTree)arithmeticExpressionContext));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.TRIM() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TRIM(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            if (ctx.trim_specification() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.trim_specification()));
            }
            if (ctx.trim_character() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.trim_character()));
            }
            if (ctx.FROM() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.FROM()));
            }
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOWER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOWER(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.UPPER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.UPPER(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression(0)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTrim_specification(EqlParser.Trim_specificationContext ctx) {
        if (ctx.LEADING() != null) {
            return List.of(new JpaQueryParsingToken(ctx.LEADING()));
        }
        if (ctx.TRAILING() != null) {
            return List.of(new JpaQueryParsingToken(ctx.TRAILING()));
        }
        return List.of(new JpaQueryParsingToken(ctx.BOTH()));
    }

    @Override
    public List<JpaQueryParsingToken> visitCast_function(EqlParser.Cast_functionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CAST(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.single_valued_path_expression()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        JpaQueryParsingToken.NOSPACE(tokens);
        if (ctx.numeric_literal() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            ctx.numeric_literal().forEach(numericLiteralContext -> {
                tokens.addAll((Collection)this.visit((ParseTree)numericLiteralContext));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFunction_invocation(EqlParser.Function_invocationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.FUNCTION() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FUNCTION(), false));
        } else if (ctx.identification_variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
            JpaQueryParsingToken.NOSPACE(tokens);
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.function_name()));
        JpaQueryParsingToken.NOSPACE(tokens);
        ctx.function_arg().forEach(functionArgContext -> {
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            tokens.addAll((Collection)this.visit((ParseTree)functionArgContext));
            JpaQueryParsingToken.NOSPACE(tokens);
        });
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExtract_datetime_field(EqlParser.Extract_datetime_fieldContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXTRACT(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_field()));
        tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDatetime_field(EqlParser.Datetime_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitExtract_datetime_part(EqlParser.Extract_datetime_partContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXTRACT(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_part()));
        tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetime_expression()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDatetime_part(EqlParser.Datetime_partContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitFunction_arg(EqlParser.Function_argContext ctx) {
        if (ctx.literal() != null) {
            return (List)this.visit((ParseTree)ctx.literal());
        }
        if (ctx.state_valued_path_expression() != null) {
            return (List)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        if (ctx.input_parameter() != null) {
            return (List)this.visit((ParseTree)ctx.input_parameter());
        }
        return (List)this.visit((ParseTree)ctx.scalar_expression());
    }

    @Override
    public List<JpaQueryParsingToken> visitCase_expression(EqlParser.Case_expressionContext ctx) {
        if (ctx.general_case_expression() != null) {
            return (List)this.visit((ParseTree)ctx.general_case_expression());
        }
        if (ctx.simple_case_expression() != null) {
            return (List)this.visit((ParseTree)ctx.simple_case_expression());
        }
        if (ctx.coalesce_expression() != null) {
            return (List)this.visit((ParseTree)ctx.coalesce_expression());
        }
        return (List)this.visit((ParseTree)ctx.nullif_expression());
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneral_case_expression(EqlParser.General_case_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CASE()));
        ctx.when_clause().forEach(whenClauseContext -> tokens.addAll((Collection)this.visit((ParseTree)whenClauseContext)));
        tokens.add(new JpaQueryParsingToken(ctx.ELSE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        tokens.add(new JpaQueryParsingToken(ctx.END()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWhen_clause(EqlParser.When_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.conditional_expression()));
        tokens.add(new JpaQueryParsingToken(ctx.THEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_case_expression(EqlParser.Simple_case_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CASE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.case_operand()));
        ctx.simple_when_clause().forEach(simpleWhenClauseContext -> tokens.addAll((Collection)this.visit((ParseTree)simpleWhenClauseContext)));
        tokens.add(new JpaQueryParsingToken(ctx.ELSE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression()));
        tokens.add(new JpaQueryParsingToken(ctx.END()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCase_operand(EqlParser.Case_operandContext ctx) {
        if (ctx.state_valued_path_expression() != null) {
            return (List)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        return (List)this.visit((ParseTree)ctx.type_discriminator());
    }

    @Override
    public List<JpaQueryParsingToken> visitSimple_when_clause(EqlParser.Simple_when_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.THEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCoalesce_expression(EqlParser.Coalesce_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.COALESCE(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        ctx.scalar_expression().forEach(scalarExpressionContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)scalarExpressionContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitNullif_expression(EqlParser.Nullif_expressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.NULLIF(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression(0)));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.scalar_expression(1)));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTrim_character(EqlParser.Trim_characterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
        }
        if (ctx.character_valued_input_parameter() != null) {
            return (List)this.visit((ParseTree)ctx.character_valued_input_parameter());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitIdentification_variable(EqlParser.Identification_variableContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.IDENTIFICATION_VARIABLE()));
        }
        if (ctx.f != null) {
            return List.of(new JpaQueryParsingToken(ctx.f));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitConstructor_name(EqlParser.Constructor_nameContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_name()));
        JpaQueryParsingToken.NOSPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitLiteral(EqlParser.LiteralContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.STRINGLITERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.STRINGLITERAL()));
        } else if (ctx.INTLITERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INTLITERAL()));
        } else if (ctx.FLOATLITERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FLOATLITERAL()));
        } else if (ctx.LONGLITERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LONGLITERAL()));
        } else if (ctx.boolean_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.boolean_literal()));
        } else if (ctx.entity_type_literal() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_type_literal()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInput_parameter(EqlParser.Input_parameterContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.INTLITERAL() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_QUESTION_MARK);
            tokens.add(new JpaQueryParsingToken(ctx.INTLITERAL()));
        } else if (ctx.identification_variable() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_COLON);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitPattern_value(EqlParser.Pattern_valueContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.string_expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDate_time_timestamp_literal(EqlParser.Date_time_timestamp_literalContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.STRINGLITERAL()));
        }
        if (ctx.DATELITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.DATELITERAL()));
        }
        if (ctx.TIMELITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.TIMELITERAL()));
        }
        if (ctx.TIMESTAMPLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.TIMESTAMPLITERAL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitEntity_type_literal(EqlParser.Entity_type_literalContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitEscape_character(EqlParser.Escape_characterContext ctx) {
        return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
    }

    @Override
    public List<JpaQueryParsingToken> visitNumeric_literal(EqlParser.Numeric_literalContext ctx) {
        if (ctx.INTLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.INTLITERAL()));
        }
        if (ctx.FLOATLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.FLOATLITERAL()));
        }
        if (ctx.LONGLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.LONGLITERAL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitBoolean_literal(EqlParser.Boolean_literalContext ctx) {
        if (ctx.TRUE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.FALSE()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitEnum_literal(EqlParser.Enum_literalContext ctx) {
        return (List)this.visit((ParseTree)ctx.state_field_path_expression());
    }

    @Override
    public List<JpaQueryParsingToken> visitString_literal(EqlParser.String_literalContext ctx) {
        if (ctx.CHARACTER() != null) {
            return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
        }
        if (ctx.STRINGLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.STRINGLITERAL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSingle_valued_embeddable_object_field(EqlParser.Single_valued_embeddable_object_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitSubtype(EqlParser.SubtypeContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_valued_field(EqlParser.Collection_valued_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitSingle_valued_object_field(EqlParser.Single_valued_object_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitState_field(EqlParser.State_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_value_field(EqlParser.Collection_value_fieldContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitEntity_name(EqlParser.Entity_nameContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.reserved_word().forEach(identificationVariableContext -> {
            tokens.addAll((Collection<JpaQueryParsingToken>)this.visitReserved_word((EqlParser.Reserved_wordContext)((Object)identificationVariableContext)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitResult_variable(EqlParser.Result_variableContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitSuperquery_identification_variable(EqlParser.Superquery_identification_variableContext ctx) {
        return (List)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public List<JpaQueryParsingToken> visitCollection_valued_input_parameter(EqlParser.Collection_valued_input_parameterContext ctx) {
        return (List)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public List<JpaQueryParsingToken> visitSingle_valued_input_parameter(EqlParser.Single_valued_input_parameterContext ctx) {
        return (List)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public List<JpaQueryParsingToken> visitFunction_name(EqlParser.Function_nameContext ctx) {
        return (List)this.visit((ParseTree)ctx.string_literal());
    }

    @Override
    public List<JpaQueryParsingToken> visitCharacter_valued_input_parameter(EqlParser.Character_valued_input_parameterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
        }
        if (ctx.input_parameter() != null) {
            return (List)this.visit((ParseTree)ctx.input_parameter());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitReserved_word(EqlParser.Reserved_wordContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.IDENTIFICATION_VARIABLE()));
        }
        if (ctx.f != null) {
            return List.of(new JpaQueryParsingToken(ctx.f));
        }
        return List.of();
    }
}

