/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;

class HqlQueryRenderer
extends HqlBaseVisitor<QueryTokenStream> {
    HqlQueryRenderer() {
    }

    static boolean isSubquery(ParserRuleContext ctx) {
        if (ctx instanceof HqlParser.SubqueryContext || ctx instanceof HqlParser.CteContext) {
            return true;
        }
        if (ctx instanceof HqlParser.SelectStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.InsertStatementContext) {
            return false;
        }
        return HqlQueryRenderer.isSubquery(ctx.getParent());
    }

    @Override
    public QueryTokenStream visitStart(HqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitQl_statement(HqlParser.Ql_statementContext ctx) {
        if (ctx.selectStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.selectStatement());
        }
        if (ctx.updateStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.updateStatement());
        }
        if (ctx.deleteStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.deleteStatement());
        }
        if (ctx.insertStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.insertStatement());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public QueryTokenStream visitQueryExpression(HqlParser.QueryExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.withClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withClause()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.orderedQuery(0)));
        int i = 1;
        while (i < ctx.orderedQuery().size()) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.setOperator(i - 1)));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.orderedQuery(i)));
            ++i;
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWithClause(HqlParser.WithClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.QueryRendererBuilder.from(QueryTokens.TOKEN_WITH);
        builder.append(QueryTokenStream.concatExpressions(ctx.cte(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCte(HqlParser.CteContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_AS);
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.MATERIALIZED() != null) {
            builder.append(QueryTokens.TOKEN_MATERIALIZED);
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.searchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.searchClause()));
        }
        if (ctx.cycleClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.cycleClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchClause(HqlParser.SearchClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SEARCH()));
        if (ctx.BREADTH() != null) {
            builder.append(QueryTokens.expression(ctx.BREADTH()));
        } else if (ctx.DEPTH() != null) {
            builder.append(QueryTokens.expression(ctx.DEPTH()));
        }
        builder.append(QueryTokens.expression(ctx.FIRST()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.searchSpecifications()));
        builder.append(QueryTokens.expression(ctx.SET()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchSpecifications(HqlParser.SearchSpecificationsContext ctx) {
        return QueryTokenStream.concat(ctx.searchSpecification(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitSearchSpecification(HqlParser.SearchSpecificationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (ctx.sortDirection() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCycleClause(HqlParser.CycleClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CYCLE().getText()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.cteAttributes()));
        builder.append(QueryTokens.expression(ctx.SET().getText()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier(0)));
        if (ctx.TO() != null) {
            builder.append(QueryTokens.expression(ctx.TO().getText()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.literal(0)));
            builder.append(QueryTokens.expression(ctx.DEFAULT().getText()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.literal(1)));
        }
        if (ctx.USING() != null) {
            builder.append(QueryTokens.expression(ctx.USING().getText()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier(1)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCteAttributes(HqlParser.CteAttributesContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.query() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        if (ctx.queryOrder() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryOrder()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectQuery(HqlParser.SelectQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.selectClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.selectClause()));
        }
        if (ctx.fromClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.havingClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromQuery(HqlParser.FromQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.fromClause()));
        if (ctx.whereClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.selectClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        if (ctx.limitClause() == null && ctx.offsetClause() == null && ctx.fetchClause() == null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.orderByClause());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        if (ctx.limitClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fetchClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromClause(HqlParser.FromClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.entityWithJoins(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fromRoot()));
        builder.appendInline(QueryTokenStream.concat(ctx.joinSpecifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinSpecifier(HqlParser.JoinSpecifierContext ctx) {
        if (ctx.join() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.join());
        }
        if (ctx.crossJoin() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.crossJoin());
        }
        if (ctx.jpaCollectionJoin() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jpaCollectionJoin());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitFromRoot(HqlParser.FromRootContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.entityName() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        } else if (ctx.subquery() != null) {
            if (ctx.LATERAL() != null) {
                builder.append(QueryTokens.expression(ctx.LATERAL()));
            }
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.appendExpression(nested);
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin(HqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinType()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        if (ctx.FETCH() != null) {
            builder.append(QueryTokens.expression(ctx.FETCH()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinPath(HqlParser.JoinPathContext ctx) {
        HqlParser.VariableContext variable = ctx.variable();
        if (variable == null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.path());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)variable));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LATERAL() != null) {
            builder.append(QueryTokens.expression(ctx.LATERAL()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UPDATE()));
        if (ctx.VERSIONED() != null) {
            builder.append(QueryTokens.expression(ctx.VERSIONED()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.setClause()));
        if (ctx.whereClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTargetEntity(HqlParser.TargetEntityContext ctx) {
        HqlParser.VariableContext variable = ctx.variable();
        if (variable == null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entityName());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)variable));
        return builder;
    }

    @Override
    public QueryTokenStream visitSetClause(HqlParser.SetClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SET()));
        return builder.append(QueryTokenStream.concat(ctx.assignment(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitAssignment(HqlParser.AssignmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DELETE()));
        if (ctx.FROM() != null) {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        if (ctx.whereClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.INSERT()));
        if (ctx.INTO() != null) {
            builder.append(QueryTokens.expression(ctx.INTO()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetFields()));
        if (ctx.queryExpression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
        } else if (ctx.valuesList() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.valuesList()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTargetFields(HqlParser.TargetFieldsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.simplePath(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitValuesList(HqlParser.ValuesListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.VALUES()));
        builder.append(QueryTokenStream.concat(ctx.values(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitValues(HqlParser.ValuesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantiation(HqlParser.InstantiationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.instantiationTarget()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.instantiationArguments()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAlias(HqlParser.AliasContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedItem(HqlParser.GroupedItemContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSortedItem(HqlParser.SortedItemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.sortExpression()));
        if (ctx.sortDirection() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSortDirection(HqlParser.SortDirectionContext ctx) {
        if (ctx.ASC() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.DESC()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNullsPrecedence(HqlParser.NullsPrecedenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NULLS()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else if (ctx.LAST() != null) {
            builder.append(QueryTokens.expression(ctx.LAST()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLimitClause(HqlParser.LimitClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.LIMIT()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.OFFSET()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        if (ctx.ROW() != null) {
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFetchClause(HqlParser.FetchClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FETCH()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else if (ctx.NEXT() != null) {
            builder.append(QueryTokens.expression(ctx.NEXT()));
        }
        if (ctx.parameterOrIntegerLiteral() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        } else if (ctx.parameterOrNumberLiteral() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrNumberLiteral()));
        }
        if (ctx.ROW() != null) {
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        }
        if (ctx.ONLY() != null) {
            builder.append(QueryTokens.expression(ctx.ONLY()));
        } else if (ctx.WITH() != null) {
            builder.append(QueryTokens.expression(ctx.WITH()));
            builder.append(QueryTokens.expression(ctx.TIES()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery(HqlParser.SubqueryContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public QueryTokenStream visitSelectClause(HqlParser.SelectClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.selectionList()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectionList(HqlParser.SelectionListContext ctx) {
        return QueryTokenStream.concat(ctx.selection(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitSelection(HqlParser.SelectionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectExpression()));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectExpression(HqlParser.SelectExpressionContext ctx) {
        if (ctx.instantiation() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.instantiation());
        }
        if (ctx.mapEntrySelection() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.mapEntrySelection());
        }
        if (ctx.jpaSelectObjectSyntax() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jpaSelectObjectSyntax());
        }
        if (ctx.expressionOrPredicate() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ENTRY()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.OBJECT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitWhereClause(HqlParser.WhereClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHERE()));
        builder.append(QueryTokenStream.concatExpressions(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinType(HqlParser.JoinTypeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INNER() != null) {
            builder.append(QueryTokens.expression(ctx.INNER()));
        }
        if (ctx.LEFT() != null) {
            builder.append(QueryTokens.expression(ctx.LEFT()));
        }
        if (ctx.RIGHT() != null) {
            builder.append(QueryTokens.expression(ctx.RIGHT()));
        }
        if (ctx.FULL() != null) {
            builder.append(QueryTokens.expression(ctx.FULL()));
        }
        if (ctx.OUTER() != null) {
            builder.append(QueryTokens.expression(ctx.OUTER()));
        }
        if (ctx.CROSS() != null) {
            builder.append(QueryTokens.expression(ctx.CROSS()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CROSS()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinRestriction(HqlParser.JoinRestrictionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.ON() != null) {
            builder.append(QueryTokens.expression(ctx.ON()));
        } else if (ctx.WITH() != null) {
            builder.append(QueryTokens.expression(ctx.WITH()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.append(QueryTokens.token(ctx.IN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.groupedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.sortedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitHavingClause(HqlParser.HavingClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.HAVING()));
        builder.appendExpression(QueryTokenStream.concat(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSetOperator(HqlParser.SetOperatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.UNION() != null) {
            builder.append(QueryTokens.expression(ctx.UNION()));
        } else if (ctx.INTERSECT() != null) {
            builder.append(QueryTokens.expression(ctx.INTERSECT()));
        } else if (ctx.EXCEPT() != null) {
            builder.append(QueryTokens.expression(ctx.EXCEPT()));
        }
        if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLiteral(HqlParser.LiteralContext ctx) {
        if (ctx.NULL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.NULL()));
        }
        if (ctx.booleanLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.booleanLiteral());
        }
        if (ctx.stringLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.stringLiteral());
        }
        if (ctx.numericLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral());
        }
        if (ctx.dateTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.dateTimeLiteral());
        }
        if (ctx.binaryLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.binaryLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.FALSE()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitStringLiteral(HqlParser.StringLiteralContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.STRINGLITERAL()));
        }
        if (ctx.CHARACTER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.CHARACTER()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNumericLiteral(HqlParser.NumericLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.FLOAT_LITERAL()));
        }
        if (ctx.HEXLITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.HEXLITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LOCAL_DATE() != null) {
            builder.append(QueryTokens.expression(ctx.LOCAL_DATE()));
        } else if (ctx.LOCAL_TIME() != null) {
            builder.append(QueryTokens.expression(ctx.LOCAL_TIME()));
        } else if (ctx.LOCAL_DATETIME() != null) {
            builder.append(QueryTokens.expression(ctx.LOCAL_DATETIME()));
        } else if (ctx.CURRENT_DATE() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_DATE()));
        } else if (ctx.CURRENT_TIME() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIME()));
        } else if (ctx.CURRENT_TIMESTAMP() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIMESTAMP()));
        } else if (ctx.OFFSET_DATETIME() != null) {
            builder.append(QueryTokens.expression(ctx.OFFSET_DATETIME()));
        } else {
            if (ctx.LOCAL() != null) {
                builder.append(QueryTokens.expression(ctx.LOCAL()));
            } else if (ctx.CURRENT() != null) {
                builder.append(QueryTokens.expression(ctx.CURRENT()));
            } else if (ctx.OFFSET() != null) {
                builder.append(QueryTokens.expression(ctx.OFFSET()));
            }
            if (ctx.DATE() != null) {
                builder.append(QueryTokens.expression(ctx.DATE()));
            } else if (ctx.TIME() != null) {
                builder.append(QueryTokens.expression(ctx.TIME()));
            } else if (ctx.DATETIME() != null) {
                builder.append(QueryTokens.expression(ctx.DATETIME()));
            }
            if (ctx.INSTANT() != null) {
                builder.append(QueryTokens.expression(ctx.INSTANT()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        if (ctx.YEAR() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.YEAR()));
        }
        if (ctx.MONTH() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.MONTH()));
        }
        if (ctx.DAY() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.DAY()));
        }
        if (ctx.WEEK() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.WEEK()));
        }
        if (ctx.QUARTER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.QUARTER()));
        }
        if (ctx.HOUR() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.HOUR()));
        }
        if (ctx.MINUTE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.MINUTE()));
        }
        if (ctx.SECOND() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.SECOND()));
        }
        if (ctx.NANOSECOND() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.NANOSECOND()));
        }
        if (ctx.EPOCH() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.EPOCH()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.BINARY_LITERAL() != null) {
            builder.append(QueryTokens.expression(ctx.BINARY_LITERAL()));
        } else if (ctx.HEXLITERAL() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_BRACE);
            builder.append(QueryTokenStream.concat(ctx.HEXLITERAL(), it -> QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(it)), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPlainPrimaryExpression(HqlParser.PlainPrimaryExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.primaryExpression());
    }

    @Override
    public QueryTokenStream visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.TOKEN_DOUBLE_PIPE);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitDayOfWeekExpression(HqlParser.DayOfWeekExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DAY()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.WEEK()));
        return builder;
    }

    @Override
    public QueryTokenStream visitDayOfMonthExpression(HqlParser.DayOfMonthExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DAY()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.MONTH()));
        return builder;
    }

    @Override
    public QueryTokenStream visitWeekOfYearExpression(HqlParser.WeekOfYearExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WEEK()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.YEAR()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral()));
        return builder;
    }

    @Override
    public QueryTokenStream visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.op));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitSignedExpression(HqlParser.SignedExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        return builder;
    }

    @Override
    public QueryTokenStream visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.caseList());
    }

    @Override
    public QueryTokenStream visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
    }

    @Override
    public QueryTokenStream visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
    }

    @Override
    public QueryTokenStream visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.function());
    }

    @Override
    public QueryTokenStream visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment());
    }

    @Override
    public QueryTokenStream visitIdentificationVariable(HqlParser.IdentificationVariableContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.simplePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simplePath());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitPath(HqlParser.PathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.treatedPath() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.treatedPath()));
            if (ctx.pathContinutation() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinutation()));
            }
        } else if (ctx.generalPathFragment() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        if (ctx.indexedPathAccessFragment() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        if (ctx.generalPathFragment() != null) {
            builder.append(QueryTokens.TOKEN_DOT);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePath(HqlParser.SimplePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (!ctx.simplePathElement().isEmpty()) {
            builder.append(QueryTokens.TOKEN_DOT);
        }
        builder.append(QueryTokenStream.concat(ctx.simplePathElement(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePathElement(HqlParser.SimplePathElementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseList(HqlParser.CaseListContext ctx) {
        if (ctx.simpleCaseExpression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simpleCaseExpression());
        }
        if (ctx.searchedCaseExpression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.searchedCaseExpression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        ctx.caseWhenExpressionClause().forEach(caseWhenExpressionClauseContext -> builder.append((QueryTokenStream)this.visit((ParseTree)caseWhenExpressionClauseContext)));
        if (ctx.ELSE() != null) {
            builder.append(QueryTokens.expression(ctx.ELSE()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        }
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.append(QueryTokenStream.concat(ctx.caseWhenPredicateClause(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        if (ctx.ELSE() != null) {
            builder.append(QueryTokens.expression(ctx.ELSE()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        }
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseWhenExpressionClause(HqlParser.CaseWhenExpressionClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseWhenPredicateClause(HqlParser.CaseWhenPredicateClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.functionName()));
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.functionArguments() != null) {
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.functionArguments()));
        } else if (ctx.ASTERISK() != null) {
            nested.append(QueryTokens.token(ctx.ASTERISK()));
        }
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.append(nested);
        if (ctx.pathContinutation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinutation()));
        }
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.withinGroup() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withinGroup()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctionWithSubquery(HqlParser.FunctionWithSubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.functionName()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCastFunctionInvocation(HqlParser.CastFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.castFunction());
    }

    @Override
    public QueryTokenStream visitExtractFunctionInvocation(HqlParser.ExtractFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.extractFunction());
    }

    @Override
    public QueryTokenStream visitTrimFunctionInvocation(HqlParser.TrimFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.trimFunction());
    }

    @Override
    public QueryTokenStream visitEveryFunctionInvocation(HqlParser.EveryFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.everyFunction());
    }

    @Override
    public QueryTokenStream visitAnyFunctionInvocation(HqlParser.AnyFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.anyFunction());
    }

    @Override
    public QueryTokenStream visitTreatedPathInvocation(HqlParser.TreatedPathInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.treatedPath());
    }

    @Override
    public QueryTokenStream visitFunctionArguments(HqlParser.FunctionArgumentsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitFilterClause(HqlParser.FilterClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FILTER()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitWithinGroup(HqlParser.WithinGroupContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WITHIN()));
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitOverClause(HqlParser.OverClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.OVER()));
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        ArrayList<ParserRuleContext> trees = new ArrayList<ParserRuleContext>();
        if (ctx.partitionClause() != null) {
            trees.add(ctx.partitionClause());
        }
        if (ctx.orderByClause() != null) {
            trees.add(ctx.orderByClause());
        }
        if (ctx.frameClause() != null) {
            trees.add(ctx.frameClause());
        }
        nested.appendInline(QueryTokenStream.concat(trees, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.appendInline(nested);
        return builder;
    }

    @Override
    public QueryTokenStream visitPartitionClause(HqlParser.PartitionClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.PARTITION()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitFrameClause(HqlParser.FrameClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.RANGE() != null) {
            builder.append(QueryTokens.expression(ctx.RANGE()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        } else if (ctx.GROUPS() != null) {
            builder.append(QueryTokens.expression(ctx.GROUPS()));
        }
        if (ctx.BETWEEN() != null) {
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameStart()));
        if (ctx.AND() != null) {
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameEnd()));
        }
        if (ctx.frameExclusion() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameExclusion()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitUnboundedPrecedingFrameStart(HqlParser.UnboundedPrecedingFrameStartContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UNBOUNDED()));
        builder.append(QueryTokens.expression(ctx.PRECEDING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionPrecedingFrameStart(HqlParser.ExpressionPrecedingFrameStartContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.PRECEDING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentRowFrameStart(HqlParser.CurrentRowFrameStartContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CURRENT()));
        builder.append(QueryTokens.expression(ctx.ROW()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionFollowingFrameStart(HqlParser.ExpressionFollowingFrameStartContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.FOLLOWING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentRowFrameExclusion(HqlParser.CurrentRowFrameExclusionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXCLUDE()));
        builder.append(QueryTokens.expression(ctx.CURRENT()));
        builder.append(QueryTokens.expression(ctx.ROW()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupFrameExclusion(HqlParser.GroupFrameExclusionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXCLUDE()));
        builder.append(QueryTokens.expression(ctx.GROUP()));
        return builder;
    }

    @Override
    public QueryTokenStream visitTiesFrameExclusion(HqlParser.TiesFrameExclusionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXCLUDE()));
        builder.append(QueryTokens.expression(ctx.TIES()));
        return builder;
    }

    @Override
    public QueryTokenStream visitNoOthersFrameExclusion(HqlParser.NoOthersFrameExclusionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXCLUDE()));
        builder.append(QueryTokens.expression(ctx.NO()));
        builder.append(QueryTokens.expression(ctx.OTHERS()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionPrecedingFrameEnd(HqlParser.ExpressionPrecedingFrameEndContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.PRECEDING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentRowFrameEnd(HqlParser.CurrentRowFrameEndContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CURRENT()));
        builder.append(QueryTokens.expression(ctx.ROW()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionFollowingFrameEnd(HqlParser.ExpressionFollowingFrameEndContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.FOLLOWING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitUnboundedFollowingFrameEnd(HqlParser.UnboundedFollowingFrameEndContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UNBOUNDED()));
        builder.append(QueryTokens.expression(ctx.FOLLOWING()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCastFunction(HqlParser.CastFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.castTarget()));
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCastTarget(HqlParser.CastTargetContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.castTargetType()));
        if (ctx.INTEGER_LITERAL() != null && !ctx.INTEGER_LITERAL().isEmpty()) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            ArrayList tokens = new ArrayList();
            ctx.INTEGER_LITERAL().forEach(terminalNode -> {
                if (!tokens.isEmpty()) {
                    tokens.add(QueryTokens.TOKEN_COMMA);
                }
                tokens.add(QueryTokens.expression(terminalNode));
            });
            builder.append(tokens);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCastTargetType(HqlParser.CastTargetTypeContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.fullTargetName));
    }

    @Override
    public QueryTokenStream visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.EXTRACT() != null) {
            builder.append(QueryTokens.token(ctx.EXTRACT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
            nested.append(QueryTokens.expression(ctx.FROM()));
            nested.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.dateTimeFunction() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.dateTimeFunction()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TRIM()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.LEADING() != null) {
            builder.append(QueryTokens.expression(ctx.LEADING()));
        } else if (ctx.TRAILING() != null) {
            builder.append(QueryTokens.expression(ctx.TRAILING()));
        } else if (ctx.BOTH() != null) {
            builder.append(QueryTokens.expression(ctx.BOTH()));
        }
        if (ctx.stringLiteral() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.stringLiteral()));
        }
        if (ctx.FROM() != null) {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDateTimeFunction(HqlParser.DateTimeFunctionContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.d));
    }

    @Override
    public QueryTokenStream visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.every));
        if (ctx.ELEMENTS() != null) {
            builder.append(QueryTokens.expression(ctx.ELEMENTS()));
        } else if (ctx.INDICES() != null) {
            builder.append(QueryTokens.expression(ctx.INDICES()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.predicate() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        } else if (ctx.subquery() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        } else if (ctx.simplePath() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.any));
        if (ctx.ELEMENTS() != null) {
            builder.append(QueryTokens.expression(ctx.ELEMENTS()));
        } else if (ctx.INDICES() != null) {
            builder.append(QueryTokens.expression(ctx.INDICES()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.predicate() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        } else if (ctx.subquery() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        } else if (ctx.simplePath() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitTreatedPath(HqlParser.TreatedPathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TREAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinutation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinutation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPathContinutation(HqlParser.PathContinutationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_DOT);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        return builder;
    }

    @Override
    public QueryTokenStream visitIsBooleanPredicate(HqlParser.IsBooleanPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.NULL() != null) {
            builder.append(QueryTokens.expression(ctx.NULL()));
        }
        if (ctx.TRUE() != null) {
            builder.append(QueryTokens.expression(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            builder.append(QueryTokens.expression(ctx.FALSE()));
        }
        if (ctx.EMPTY() != null) {
            builder.append(QueryTokens.expression(ctx.EMPTY()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.MEMBER() != null) {
            builder.append(QueryTokens.expression(ctx.MEMBER()));
        }
        if (ctx.OF() != null) {
            builder.append(QueryTokens.expression(ctx.OF()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        return builder;
    }

    @Override
    public QueryTokenStream visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
            builder.append(QueryTokens.expression(ctx.FROM()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.betweenExpression());
    }

    @Override
    public QueryTokenStream visitContainsPredicate(HqlParser.ContainsPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.CONTAINS() != null) {
            builder.append(QueryTokens.expression(ctx.CONTAINS()));
        }
        if (ctx.INCLUDES() != null) {
            builder.append(QueryTokens.expression(ctx.INCLUDES()));
        }
        if (ctx.INTERSECTS() != null) {
            builder.append(QueryTokens.expression(ctx.INTERSECTS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(0)));
        builder.append(QueryTokens.expression(ctx.OR()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitRelationalPredicate(HqlParser.RelationalPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.relationalExpression());
    }

    @Override
    public QueryTokenStream visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.existsExpression());
    }

    @Override
    public QueryTokenStream visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(0)));
        builder.append(QueryTokens.expression(ctx.AND()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.stringPatternMatching());
    }

    @Override
    public QueryTokenStream visitInPredicate(HqlParser.InPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.inExpression());
    }

    @Override
    public QueryTokenStream visitNotPredicate(HqlParser.NotPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_NOT);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionPredicate(HqlParser.ExpressionPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitExpressionOrPredicate(HqlParser.ExpressionOrPredicateContext ctx) {
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        if (ctx.predicate() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.predicate());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitRelationalExpression(HqlParser.RelationalExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitBetweenExpression(HqlParser.BetweenExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.BETWEEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        builder.append(QueryTokens.expression(ctx.AND()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(2)));
        return builder;
    }

    @Override
    public QueryTokenStream visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.LIKE() != null) {
            builder.append(QueryTokens.expression(ctx.LIKE()));
        } else if (ctx.ILIKE() != null) {
            builder.append(QueryTokens.expression(ctx.ILIKE()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        if (ctx.ESCAPE() != null) {
            builder.append(QueryTokens.expression(ctx.ESCAPE()));
            if (ctx.stringLiteral() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.stringLiteral()));
            } else if (ctx.parameter() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInExpression(HqlParser.InExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.IN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.inList()));
        return builder;
    }

    @Override
    public QueryTokenStream visitInList(HqlParser.InListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.expression(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.expression(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
        } else if (ctx.expressionOrPredicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitExistsExpression(HqlParser.ExistsExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.expression(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.expression(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.expression() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx) {
        if (ctx.LIST() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.LIST()));
        }
        if (ctx.MAP() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.MAP()));
        }
        if (ctx.simplePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simplePath());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx) {
        return QueryTokenStream.concat(ctx.instantiationArgument(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.expressionOrPredicate() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        } else if (ctx.instantiation() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.instantiation()));
        }
        if (ctx.variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.numericLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitVariable(HqlParser.VariableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.identifier() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.reservedWord() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.reservedWord()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitParameter(HqlParser.ParameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.prefix.getText().equals(":")) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.prefix.getText().equals("?")) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            if (ctx.INTEGER_LITERAL() != null) {
                builder.append(QueryTokens.expression(ctx.INTEGER_LITERAL()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityName(HqlParser.EntityNameContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitIdentifier(HqlParser.IdentifierContext ctx) {
        if (ctx.reservedWord() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reservedWord());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitCharacter(HqlParser.CharacterContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.CHARACTER()));
    }

    @Override
    public QueryTokenStream visitFunctionName(HqlParser.FunctionNameContext ctx) {
        return QueryTokenStream.concat(ctx.reservedWord(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitReservedWord(HqlParser.ReservedWordContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.IDENTIFICATION_VARIABLE()));
        }
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.f));
    }
}

