/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.util.ObjectUtils;

class HqlQueryRenderer
extends HqlBaseVisitor<QueryTokenStream> {
    HqlQueryRenderer() {
    }

    static boolean isSubquery(ParserRuleContext ctx) {
        if (ctx instanceof HqlParser.SubqueryContext || ctx instanceof HqlParser.CteContext) {
            return true;
        }
        if (ctx instanceof HqlParser.SelectStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.InsertStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.DeleteStatementContext) {
            return false;
        }
        if (ctx instanceof HqlParser.UpdateStatementContext) {
            return false;
        }
        return ctx.getParent() != null && HqlQueryRenderer.isSubquery(ctx.getParent());
    }

    @Override
    public QueryTokenStream visitStart(HqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitQl_statement(HqlParser.Ql_statementContext ctx) {
        if (ctx.selectStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.selectStatement());
        }
        if (ctx.updateStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.updateStatement());
        }
        if (ctx.deleteStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.deleteStatement());
        }
        if (ctx.insertStatement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.insertStatement());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public QueryTokenStream visitQueryExpression(HqlParser.QueryExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.withClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withClause()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.orderedQuery(0)));
        int i = 1;
        while (i < ctx.orderedQuery().size()) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.setOperator(i - 1)));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.orderedQuery(i)));
            ++i;
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWithClause(HqlParser.WithClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.QueryRendererBuilder.from(QueryTokens.TOKEN_WITH);
        builder.append(QueryTokenStream.concatExpressions(ctx.cte(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCte(HqlParser.CteContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_AS);
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.MATERIALIZED() != null) {
            builder.append(QueryTokens.TOKEN_MATERIALIZED);
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.searchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.searchClause()));
        }
        if (ctx.cycleClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.cycleClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchClause(HqlParser.SearchClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SEARCH()));
        if (ctx.BREADTH() != null) {
            builder.append(QueryTokens.expression(ctx.BREADTH()));
        } else if (ctx.DEPTH() != null) {
            builder.append(QueryTokens.expression(ctx.DEPTH()));
        }
        builder.append(QueryTokens.expression(ctx.FIRST()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.searchSpecifications()));
        builder.append(QueryTokens.expression(ctx.SET()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchSpecifications(HqlParser.SearchSpecificationsContext ctx) {
        return QueryTokenStream.concat(ctx.searchSpecification(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitSearchSpecification(HqlParser.SearchSpecificationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (ctx.sortDirection() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCycleClause(HqlParser.CycleClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CYCLE().getText()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.cteAttributes()));
        builder.append(QueryTokens.expression(ctx.SET().getText()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier(0)));
        if (ctx.TO() != null) {
            builder.append(QueryTokens.expression(ctx.TO().getText()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.literal(0)));
            builder.append(QueryTokens.expression(ctx.DEFAULT().getText()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.literal(1)));
        }
        if (ctx.USING() != null) {
            builder.append(QueryTokens.expression(ctx.USING().getText()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier(1)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCteAttributes(HqlParser.CteAttributesContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.query() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        if (ctx.queryOrder() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryOrder()));
        }
        if (ctx.limitClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fetchClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectQuery(HqlParser.SelectQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.selectClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.selectClause()));
        }
        if (ctx.fromClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.havingClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFromQuery(HqlParser.FromQueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.fromClause()));
        if (ctx.whereClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.selectClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.orderByClause());
    }

    @Override
    public QueryTokenStream visitFromClause(HqlParser.FromClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.entityWithJoins(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.fromRoot()));
        builder.appendInline(QueryTokenStream.concat(ctx.joinSpecifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinSpecifier(HqlParser.JoinSpecifierContext ctx) {
        if (ctx.join() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.join());
        }
        if (ctx.crossJoin() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.crossJoin());
        }
        if (ctx.jpaCollectionJoin() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jpaCollectionJoin());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitFromRoot(HqlParser.FromRootContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.entityName() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        } else if (ctx.subquery() != null) {
            if (ctx.LATERAL() != null) {
                builder.append(QueryTokens.expression(ctx.LATERAL()));
            }
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.append(QueryTokens.TOKEN_OPEN_PAREN);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.appendExpression(nested);
            if (ctx.variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin(HqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinType()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        if (ctx.FETCH() != null) {
            builder.append(QueryTokens.expression(ctx.FETCH()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinPath(HqlParser.JoinPathContext ctx) {
        HqlParser.VariableContext variable = ctx.variable();
        if (variable == null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.path());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)variable));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LATERAL() != null) {
            builder.append(QueryTokens.expression(ctx.LATERAL()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UPDATE()));
        if (ctx.VERSIONED() != null) {
            builder.append(QueryTokens.expression(ctx.VERSIONED()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.setClause()));
        if (ctx.whereClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTargetEntity(HqlParser.TargetEntityContext ctx) {
        HqlParser.VariableContext variable = ctx.variable();
        if (variable == null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entityName());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)variable));
        return builder;
    }

    @Override
    public QueryTokenStream visitSetClause(HqlParser.SetClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SET()));
        return builder.append(QueryTokenStream.concat(ctx.assignment(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
    }

    @Override
    public QueryTokenStream visitAssignment(HqlParser.AssignmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DELETE()));
        if (ctx.FROM() != null) {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        if (ctx.whereClause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.INSERT()));
        if (ctx.INTO() != null) {
            builder.append(QueryTokens.expression(ctx.INTO()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetEntity()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.targetFields()));
        if (ctx.queryExpression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
        } else if (ctx.valuesList() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.valuesList()));
        }
        if (ctx.conflictClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conflictClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTargetFields(HqlParser.TargetFieldsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.simplePath(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitValuesList(HqlParser.ValuesListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.VALUES()));
        builder.append(QueryTokenStream.concat(ctx.values(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitValues(HqlParser.ValuesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitConflictClause(HqlParser.ConflictClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ON()));
        builder.append(QueryTokens.expression(ctx.CONFLICT()));
        if (ctx.conflictTarget() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conflictTarget()));
        }
        builder.append(QueryTokens.expression(ctx.DO()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conflictAction()));
        return builder;
    }

    @Override
    public QueryTokenStream visitConflictTarget(HqlParser.ConflictTargetContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.identifier() != null) {
            builder.append(QueryTokens.expression(ctx.ON()));
            builder.append(QueryTokens.expression(ctx.CONSTRAINT()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        }
        if (!ObjectUtils.isEmpty(ctx.simplePath())) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokenStream.concat(ctx.simplePath(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitConflictAction(HqlParser.ConflictActionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.NOTHING() != null) {
            builder.append(QueryTokens.expression(ctx.NOTHING()));
        } else {
            builder.append(QueryTokens.expression(ctx.UPDATE()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.setClause()));
            if (ctx.whereClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantiation(HqlParser.InstantiationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.instantiationTarget()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.instantiationArguments()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedItem(HqlParser.GroupedItemContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSortedItem(HqlParser.SortedItemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.sortExpression()));
        if (ctx.sortDirection() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSortDirection(HqlParser.SortDirectionContext ctx) {
        if (ctx.ASC() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.DESC()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNullsPrecedence(HqlParser.NullsPrecedenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NULLS()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else if (ctx.LAST() != null) {
            builder.append(QueryTokens.expression(ctx.LAST()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLimitClause(HqlParser.LimitClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.LIMIT()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.OFFSET()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        if (ctx.ROW() != null) {
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFetchClause(HqlParser.FetchClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FETCH()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else if (ctx.NEXT() != null) {
            builder.append(QueryTokens.expression(ctx.NEXT()));
        }
        if (ctx.parameterOrIntegerLiteral() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        } else if (ctx.parameterOrNumberLiteral() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameterOrNumberLiteral()));
        }
        if (ctx.ROW() != null) {
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        }
        if (ctx.ONLY() != null) {
            builder.append(QueryTokens.expression(ctx.ONLY()));
        } else if (ctx.WITH() != null) {
            builder.append(QueryTokens.expression(ctx.WITH()));
            builder.append(QueryTokens.expression(ctx.TIES()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery(HqlParser.SubqueryContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public QueryTokenStream visitSelectClause(HqlParser.SelectClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.selectionList()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectionList(HqlParser.SelectionListContext ctx) {
        return QueryTokenStream.concat(ctx.selection(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitSelection(HqlParser.SelectionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.selectExpression()));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelectExpression(HqlParser.SelectExpressionContext ctx) {
        if (ctx.instantiation() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.instantiation());
        }
        if (ctx.mapEntrySelection() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.mapEntrySelection());
        }
        if (ctx.jpaSelectObjectSyntax() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jpaSelectObjectSyntax());
        }
        if (ctx.expressionOrPredicate() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ENTRY()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.OBJECT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitWhereClause(HqlParser.WhereClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHERE()));
        builder.append(QueryTokenStream.concatExpressions(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinType(HqlParser.JoinTypeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INNER() != null) {
            builder.append(QueryTokens.expression(ctx.INNER()));
        }
        if (ctx.LEFT() != null) {
            builder.append(QueryTokens.expression(ctx.LEFT()));
        }
        if (ctx.RIGHT() != null) {
            builder.append(QueryTokens.expression(ctx.RIGHT()));
        }
        if (ctx.FULL() != null) {
            builder.append(QueryTokens.expression(ctx.FULL()));
        }
        if (ctx.OUTER() != null) {
            builder.append(QueryTokens.expression(ctx.OUTER()));
        }
        if (ctx.CROSS() != null) {
            builder.append(QueryTokens.expression(ctx.CROSS()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CROSS()));
        builder.append(QueryTokens.expression(ctx.JOIN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entityName()));
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoinRestriction(HqlParser.JoinRestrictionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.ON() != null) {
            builder.append(QueryTokens.expression(ctx.ON()));
        } else if (ctx.WITH() != null) {
            builder.append(QueryTokens.expression(ctx.WITH()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.append(QueryTokens.token(ctx.IN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.groupedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.sortedItem(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitHavingClause(HqlParser.HavingClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.HAVING()));
        builder.appendExpression(QueryTokenStream.concat(ctx.predicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSetOperator(HqlParser.SetOperatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.UNION() != null) {
            builder.append(QueryTokens.expression(ctx.UNION()));
        } else if (ctx.INTERSECT() != null) {
            builder.append(QueryTokens.expression(ctx.INTERSECT()));
        } else if (ctx.EXCEPT() != null) {
            builder.append(QueryTokens.expression(ctx.EXCEPT()));
        }
        if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLiteral(HqlParser.LiteralContext ctx) {
        if (ctx.NULL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.NULL()));
        }
        if (ctx.booleanLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.booleanLiteral());
        }
        if (ctx.JAVA_STRING_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.JAVA_STRING_LITERAL()));
        }
        if (ctx.STRING_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.STRING_LITERAL()));
        }
        if (ctx.numericLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral());
        }
        if (ctx.temporalLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.temporalLiteral());
        }
        if (ctx.arrayLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.arrayLiteral());
        }
        if (ctx.generalizedLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.generalizedLiteral());
        }
        if (ctx.binaryLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.binaryLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.FALSE()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNumericLiteral(HqlParser.NumericLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
        }
        if (ctx.LONG_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.LONG_LITERAL()));
        }
        if (ctx.BIG_INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.BIG_INTEGER_LITERAL()));
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.FLOAT_LITERAL()));
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.DOUBLE_LITERAL()));
        }
        if (ctx.BIG_DECIMAL_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.BIG_DECIMAL_LITERAL()));
        }
        if (ctx.HEX_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.HEX_LITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        if (ctx.localDateTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.localDateTimeLiteral());
        }
        if (ctx.offsetDateTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTimeLiteral());
        }
        if (ctx.zonedDateTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.zonedDateTimeLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DATETIME() != null) {
            if (ctx.LOCAL() != null) {
                builder.append(QueryTokens.expression(ctx.LOCAL()));
            }
            builder.append(QueryTokens.expression(ctx.DATETIME()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.localDateTime()));
        } else {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.localDateTime()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DATETIME() != null) {
            if (ctx.ZONED() != null) {
                builder.append(QueryTokens.expression(ctx.ZONED()));
            }
            builder.append(QueryTokens.expression(ctx.DATETIME()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.zonedDateTime()));
        } else {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.zonedDateTime()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DATETIME() != null) {
            if (ctx.OFFSET() != null) {
                builder.append(QueryTokens.expression(ctx.OFFSET()));
            }
            builder.append(QueryTokens.expression(ctx.DATETIME()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTimeWithMinutes()));
        } else {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTime()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DATE() != null) {
            if (ctx.LOCAL() != null) {
                builder.append(QueryTokens.expression(ctx.LOCAL()));
            }
            builder.append(QueryTokens.expression(ctx.DATE()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        } else {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.date()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TIME() != null) {
            if (ctx.LOCAL() != null) {
                builder.append(QueryTokens.expression(ctx.LOCAL()));
            }
            builder.append(QueryTokens.expression(ctx.TIME()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        } else {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.time()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDateTime(HqlParser.DateTimeContext ctx) {
        if (ctx.localDateTime() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.localDateTime());
        }
        if (ctx.offsetDateTime() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTime());
        }
        if (ctx.zonedDateTime() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.zonedDateTime());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitLocalDateTime(HqlParser.LocalDateTimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        return builder;
    }

    @Override
    public QueryTokenStream visitZonedDateTime(HqlParser.ZonedDateTimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.zoneId()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.offset()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.date()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.time()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.offsetWithMinutes()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("ts"));
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.dateTime() != null ? ctx.dateTime() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("d"));
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.date() != null ? ctx.date() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_BRACE);
        builder.append(QueryTokens.token("t"));
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.time() != null ? ctx.time() : ctx.genericTemporalLiteralText())));
        builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        return builder;
    }

    @Override
    public QueryTokenStream visitGenericTemporalLiteralText(HqlParser.GenericTemporalLiteralTextContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitArrayLiteral(HqlParser.ArrayLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalizedLiteralType()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalizedLiteralText()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneralizedLiteralType(HqlParser.GeneralizedLiteralTypeContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitGeneralizedLiteralText(HqlParser.GeneralizedLiteralTextContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitDate(HqlParser.DateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.year()));
        builder.append(QueryTokens.TOKEN_DASH);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.month()));
        builder.append(QueryTokens.TOKEN_DASH);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.day()));
        return builder;
    }

    @Override
    public QueryTokenStream visitTime(HqlParser.TimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        if (ctx.second() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.second()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffset(HqlParser.OffsetContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MINUS() != null) {
            builder.append(QueryTokens.token(ctx.MINUS()));
        } else if (ctx.PLUS() != null) {
            builder.append(QueryTokens.token(ctx.PLUS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        if (ctx.minute() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetWithMinutes(HqlParser.OffsetWithMinutesContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MINUS() != null) {
            builder.append(QueryTokens.token(ctx.MINUS()));
        } else if (ctx.PLUS() != null) {
            builder.append(QueryTokens.token(ctx.PLUS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.hour()));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.minute()));
        return builder;
    }

    @Override
    public QueryTokenStream visitYear(HqlParser.YearContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitMonth(HqlParser.MonthContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitDay(HqlParser.DayContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitHour(HqlParser.HourContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitMinute(HqlParser.MinuteContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitSecond(HqlParser.SecondContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
    }

    @Override
    public QueryTokenStream visitZoneId(HqlParser.ZoneIdContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        if (ctx.YEAR() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.YEAR()));
        }
        if (ctx.MONTH() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.MONTH()));
        }
        if (ctx.DAY() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.DAY()));
        }
        if (ctx.WEEK() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.WEEK()));
        }
        if (ctx.QUARTER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.QUARTER()));
        }
        if (ctx.HOUR() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.HOUR()));
        }
        if (ctx.MINUTE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.MINUTE()));
        }
        if (ctx.SECOND() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.SECOND()));
        }
        if (ctx.NANOSECOND() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.NANOSECOND()));
        }
        if (ctx.EPOCH() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.EPOCH()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitDayField(HqlParser.DayFieldContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DAY()));
        builder.append(QueryTokens.expression(ctx.OF()));
        if (ctx.MONTH() != null) {
            builder.append(QueryTokens.expression(ctx.MONTH()));
        }
        if (ctx.WEEK() != null) {
            builder.append(QueryTokens.expression(ctx.WEEK()));
        }
        if (ctx.YEAR() != null) {
            builder.append(QueryTokens.expression(ctx.YEAR()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWeekField(HqlParser.WeekFieldContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WEEK()));
        builder.append(QueryTokens.expression(ctx.OF()));
        if (ctx.MONTH() != null) {
            builder.append(QueryTokens.expression(ctx.MONTH()));
        }
        if (ctx.YEAR() != null) {
            builder.append(QueryTokens.expression(ctx.YEAR()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.OFFSET() != null) {
            builder.append(QueryTokens.expression(ctx.OFFSET()));
            if (ctx.HOUR() != null) {
                builder.append(QueryTokens.expression(ctx.HOUR()));
            }
            if (ctx.MINUTE() != null) {
                builder.append(QueryTokens.expression(ctx.MINUTE()));
            }
        }
        if (ctx.TIMEZONE_HOUR() != null) {
            builder.append(QueryTokens.expression(ctx.TIMEZONE_HOUR()));
        }
        if (ctx.TIMEZONE_HOUR() != null) {
            builder.append(QueryTokens.expression(ctx.TIMEZONE_MINUTE()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.DATE() != null ? ctx.DATE() : ctx.TIME()));
    }

    @Override
    public QueryTokenStream visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.BINARY_LITERAL() != null) {
            builder.append(QueryTokens.expression(ctx.BINARY_LITERAL()));
        } else if (ctx.HEX_LITERAL() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_BRACE);
            builder.append(QueryTokenStream.concat(ctx.HEX_LITERAL(), it -> QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(it)), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_BRACE);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTemporalLiteral(HqlParser.TemporalLiteralContext ctx) {
        if (ctx.dateTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.dateTimeLiteral());
        }
        if (ctx.dateLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.dateLiteral());
        }
        if (ctx.timeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.timeLiteral());
        }
        if (ctx.jdbcTimestampLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jdbcTimestampLiteral());
        }
        if (ctx.jdbcDateLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jdbcDateLiteral());
        }
        if (ctx.jdbcTimeLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.jdbcTimeLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitPlainPrimaryExpression(HqlParser.PlainPrimaryExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.primaryExpression());
    }

    @Override
    public QueryTokenStream visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.TOKEN_DOUBLE_PIPE);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitDayOfWeekExpression(HqlParser.DayOfWeekExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DAY()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.WEEK()));
        return builder;
    }

    @Override
    public QueryTokenStream visitDayOfMonthExpression(HqlParser.DayOfMonthExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DAY()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.MONTH()));
        return builder;
    }

    @Override
    public QueryTokenStream visitWeekOfYearExpression(HqlParser.WeekOfYearExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WEEK()));
        builder.append(QueryTokens.expression(ctx.OF()));
        builder.append(QueryTokens.expression(ctx.YEAR()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral()));
        return builder;
    }

    @Override
    public QueryTokenStream visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.op));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitSignedExpression(HqlParser.SignedExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        return builder;
    }

    @Override
    public QueryTokenStream visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.caseList());
    }

    @Override
    public QueryTokenStream visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
    }

    @Override
    public QueryTokenStream visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
    }

    @Override
    public QueryTokenStream visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entityTypeReference());
    }

    @Override
    public QueryTokenStream visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entityIdReference());
    }

    @Override
    public QueryTokenStream visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entityVersionReference());
    }

    @Override
    public QueryTokenStream visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entityNaturalIdReference());
    }

    @Override
    public QueryTokenStream visitSyntacticPathExpression(HqlParser.SyntacticPathExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.syntacticDomainPath()));
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPathContinuation(HqlParser.PathContinuationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_DOT);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityTypeReference(HqlParser.EntityTypeReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TYPE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.path() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        }
        if (ctx.parameter() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.ID()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.VERSION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.NATURALID()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.treatedNavigablePath());
        }
        if (ctx.collectionValueNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collectionValueNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.mapKeyNavigablePath());
        }
        if (ctx.toOneFkReference() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.toOneFkReference());
        }
        if (ctx.function() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function()));
            if (ctx.indexedPathAccessFragment() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
            }
            if (ctx.slicedPathAccessFragment() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.slicedPathAccessFragment()));
            }
            if (ctx.pathContinuation() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
            }
            return builder;
        }
        if (ctx.indexedPathAccessFragment() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
            return builder;
        }
        if (ctx.slicedPathAccessFragment() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.slicedPathAccessFragment()));
            return builder;
        }
        return QueryRenderer.empty();
    }

    @Override
    public QueryTokenStream visitSlicedPathAccessFragment(HqlParser.SlicedPathAccessFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.TOKEN_COLON);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.function());
    }

    @Override
    public QueryTokenStream visitStandardFunctionInvocation(HqlParser.StandardFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.standardFunction());
    }

    @Override
    public QueryTokenStream visitAggregateFunctionInvocation(HqlParser.AggregateFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.aggregateFunction());
    }

    @Override
    public QueryTokenStream visitCollectionSizeFunctionInvocation(HqlParser.CollectionSizeFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.collectionSizeFunction());
    }

    @Override
    public QueryTokenStream visitCollectionAggregateFunctionInvocation(HqlParser.CollectionAggregateFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.collectionAggregateFunction());
    }

    @Override
    public QueryTokenStream visitCollectionFunctionMisuseInvocation(HqlParser.CollectionFunctionMisuseInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.collectionFunctionMisuse());
    }

    @Override
    public QueryTokenStream visitJpaNonstandardFunctionInvocation(HqlParser.JpaNonstandardFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunction());
    }

    @Override
    public QueryTokenStream visitColumnFunctionInvocation(HqlParser.ColumnFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.columnFunction());
    }

    @Override
    public QueryTokenStream visitGenericFunctionInvocation(HqlParser.GenericFunctionInvocationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.genericFunction());
    }

    @Override
    public QueryTokenStream visitStandardFunction(HqlParser.StandardFunctionContext ctx) {
        if (ctx.castFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.castFunction());
        }
        if (ctx.extractFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.extractFunction());
        }
        if (ctx.truncFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.truncFunction());
        }
        if (ctx.formatFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.formatFunction());
        }
        if (ctx.collateFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collateFunction());
        }
        if (ctx.substringFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.substringFunction());
        }
        if (ctx.overlayFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.overlayFunction());
        }
        if (ctx.trimFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.trimFunction());
        }
        if (ctx.padFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.padFunction());
        }
        if (ctx.positionFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.positionFunction());
        }
        if (ctx.currentDateFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.currentDateFunction());
        }
        if (ctx.currentTimeFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.currentTimeFunction());
        }
        if (ctx.currentTimestampFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.currentTimestampFunction());
        }
        if (ctx.instantFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.instantFunction());
        }
        if (ctx.localDateFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.localDateFunction());
        }
        if (ctx.localTimeFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.localTimeFunction());
        }
        if (ctx.localDateTimeFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.localDateTimeFunction());
        }
        if (ctx.offsetDateTimeFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.offsetDateTimeFunction());
        }
        if (ctx.cube() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.cube());
        }
        if (ctx.rollup() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.rollup());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.SUBSTRING()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.FROM() == null) {
            builder.append(QueryTokens.TOKEN_COMMA);
        } else {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionStartArgument()));
        if (ctx.substringFunctionLengthArgument() != null) {
            if (ctx.FOR() == null) {
                builder.append(QueryTokens.TOKEN_COMMA);
            } else {
                builder.append(QueryTokens.expression(ctx.FOR()));
            }
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.substringFunctionLengthArgument()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitSubstringFunctionStartArgument(HqlParser.SubstringFunctionStartArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitSubstringFunctionLengthArgument(HqlParser.SubstringFunctionLengthArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitPadFunction(HqlParser.PadFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.PAD()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.WITH()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padLength()));
        if (ctx.padCharacter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.padSpecification()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.padCharacter()));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.padSpecification()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.LEADING() != null ? ctx.LEADING() : ctx.TRAILING()));
    }

    @Override
    public QueryTokenStream visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitPadLength(HqlParser.PadLengthContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.POSITION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.positionFunctionPatternArgument()));
        builder.append(QueryTokens.expression(ctx.IN()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.positionFunctionStringArgument()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitPositionFunctionPatternArgument(HqlParser.PositionFunctionPatternArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitPositionFunctionStringArgument(HqlParser.PositionFunctionStringArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.OVERLAY()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionStringArgument()));
        builder.append(QueryTokens.expression(ctx.PLACING()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionReplacementArgument()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionStartArgument()));
        if (ctx.overlayFunctionLengthArgument() != null) {
            builder.append(QueryTokens.expression(ctx.FOR()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.overlayFunctionLengthArgument()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitOverlayFunctionStringArgument(HqlParser.OverlayFunctionStringArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitOverlayFunctionReplacementArgument(HqlParser.OverlayFunctionReplacementArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitOverlayFunctionStartArgument(HqlParser.OverlayFunctionStartArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitOverlayFunctionLengthArgument(HqlParser.OverlayFunctionLengthArgumentContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_DATE() != null) {
            builder.append(QueryTokens.token(ctx.CURRENT_DATE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.DATE()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_TIME() != null) {
            builder.append(QueryTokens.token(ctx.CURRENT_TIME()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.TIME()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_TIMESTAMP() != null) {
            builder.append(QueryTokens.token(ctx.CURRENT_TIMESTAMP()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.TIMESTAMP()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_INSTANT() != null) {
            builder.append(QueryTokens.token(ctx.CURRENT_INSTANT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.INSTANT()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LOCAL_DATETIME() != null) {
            builder.append(QueryTokens.token(ctx.LOCAL_DATETIME()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.LOCAL()));
            builder.append(QueryTokens.expression(ctx.DATETIME()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.OFFSET_DATETIME() != null) {
            builder.append(QueryTokens.token(ctx.OFFSET_DATETIME()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.OFFSET()));
            builder.append(QueryTokens.expression(ctx.DATETIME()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LOCAL_DATE() != null) {
            builder.append(QueryTokens.token(ctx.LOCAL_DATE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.LOCAL()));
            builder.append(QueryTokens.expression(ctx.DATE()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LOCAL_TIME() != null) {
            builder.append(QueryTokens.token(ctx.LOCAL_TIME()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.append(QueryTokens.expression(ctx.LOCAL()));
            builder.append(QueryTokens.expression(ctx.TIME()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FORMAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.AS()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.format()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCollation(HqlParser.CollationContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.simplePath());
    }

    @Override
    public QueryTokenStream visitCollateFunction(HqlParser.CollateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.COLLATE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.AS()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collation()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCube(HqlParser.CubeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CUBE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitRollup(HqlParser.RollupContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.ROLLUP()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitFormat(HqlParser.FormatContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitTruncFunction(HqlParser.TruncFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TRUNC() != null) {
            builder.append(QueryTokens.token(ctx.TRUNC()));
        } else {
            builder.append(QueryTokens.token(ctx.TRUNCATE()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
        } else {
            builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaNonstandardFunction(HqlParser.JpaNonstandardFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FUNCTION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        if (ctx.castTarget() != null) {
            nested.append(QueryTokens.expression(ctx.AS()));
            nested.append((QueryTokenStream)this.visit((ParseTree)ctx.castTarget()));
        }
        if (ctx.genericFunctionArguments() != null) {
            nested.append(QueryTokens.TOKEN_COMMA);
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionArguments()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitJpaNonstandardFunctionName(HqlParser.JpaNonstandardFunctionNameContext ctx) {
        if (ctx.identifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identifier());
        }
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
    }

    @Override
    public QueryTokenStream visitColumnFunction(HqlParser.ColumnFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.COLUMN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        nested.append(QueryTokens.TOKEN_DOT);
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        if (ctx.castTarget() != null) {
            nested.append(QueryTokens.expression(ctx.AS()));
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.jpaNonstandardFunctionName()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitGenericFunctionName(HqlParser.GenericFunctionNameContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.simplePath());
    }

    @Override
    public QueryTokenStream visitGenericFunctionArguments(HqlParser.GenericFunctionArgumentsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
            builder.append(QueryTokens.TOKEN_COMMA);
        }
        builder.append(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.SIZE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitElementAggregateFunction(HqlParser.ElementAggregateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MAXELEMENT() != null || ctx.MINELEMENT() != null) {
            builder.append(QueryTokens.token(ctx.MAXELEMENT() != null ? ctx.MAXELEMENT() : ctx.MINELEMENT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.elementsValuesQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.path() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIndexAggregateFunction(HqlParser.IndexAggregateFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.MAXINDEX() != null || ctx.MININDEX() != null) {
            builder.append(QueryTokens.token(ctx.MAXINDEX() != null ? ctx.MAXINDEX() : ctx.MININDEX()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indicesKeysQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.path() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionFunctionMisuse(HqlParser.CollectionFunctionMisuseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)(ctx.elementsValuesQuantifier() != null ? ctx.elementsValuesQuantifier() : ctx.indicesKeysQuantifier())));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAggregateFunction(HqlParser.AggregateFunctionContext ctx) {
        if (ctx.everyFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.everyFunction());
        }
        if (ctx.anyFunction() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.anyFunction());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.listaggFunction());
    }

    @Override
    public QueryTokenStream visitEveryAllQuantifier(HqlParser.EveryAllQuantifierContext ctx) {
        if (ctx.EVERY() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.EVERY()));
        }
        return QueryRenderer.from(QueryTokens.token(ctx.ALL()));
    }

    @Override
    public QueryTokenStream visitAnySomeQuantifier(HqlParser.AnySomeQuantifierContext ctx) {
        if (ctx.ANY() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.ANY()));
        }
        return QueryRenderer.from(QueryTokens.token(ctx.SOME()));
    }

    @Override
    public QueryTokenStream visitListaggFunction(HqlParser.ListaggFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.LISTAGG()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        if (ctx.onOverflowClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.onOverflowClause()));
        }
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.withinGroupClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withinGroupClause()));
        }
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitOnOverflowClause(HqlParser.OnOverflowClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ON()));
        builder.append(QueryTokens.expression(ctx.OVERFLOW()));
        if (ctx.ERROR() != null) {
            builder.append(QueryTokens.expression(ctx.ERROR()));
        } else {
            builder.append(QueryTokens.expression(ctx.TRUNCATE()));
            if (ctx.expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            }
            if (ctx.WITH() != null) {
                builder.append(QueryTokens.expression(ctx.WITH()));
            }
            if (ctx.WITHOUT() != null) {
                builder.append(QueryTokens.expression(ctx.WITHOUT()));
            }
            if (ctx.COUNT() != null) {
                builder.append(QueryTokens.expression(ctx.COUNT()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWithinGroupClause(HqlParser.WithinGroupClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WITHIN()));
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.orderByClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitNullsClause(HqlParser.NullsClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.IGNORE() != null) {
            builder.append(QueryTokens.expression(ctx.IGNORE()));
        } else {
            builder.append(QueryTokens.expression(ctx.RESPECT()));
        }
        builder.append(QueryTokens.expression(ctx.NULLS()));
        return builder;
    }

    @Override
    public QueryTokenStream visitNthSideClause(HqlParser.NthSideClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.expression(ctx.FIRST()));
        } else {
            builder.append(QueryTokens.expression(ctx.LAST()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFrameStart(HqlParser.FrameStartContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.UNBOUNDED() != null) {
            builder.append(QueryTokens.expression(ctx.UNBOUNDED()));
            builder.append(QueryTokens.expression(ctx.PRECEDING()));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.expression(ctx.PRECEDING() != null ? ctx.PRECEDING() : ctx.FOLLOWING()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFrameEnd(HqlParser.FrameEndContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.UNBOUNDED() != null) {
            builder.append(QueryTokens.expression(ctx.UNBOUNDED()));
            builder.append(QueryTokens.expression(ctx.FOLLOWING()));
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.expression(ctx.PRECEDING() != null ? ctx.PRECEDING() : ctx.FOLLOWING()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFrameExclusion(HqlParser.FrameExclusionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXCLUDE()));
        if (ctx.CURRENT() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT()));
            builder.append(QueryTokens.expression(ctx.ROW()));
        } else if (ctx.GROUP() != null) {
            builder.append(QueryTokens.expression(ctx.GROUP()));
        } else if (ctx.TIES() != null) {
            builder.append(QueryTokens.expression(ctx.TIES()));
        } else {
            builder.append(QueryTokens.expression(ctx.NO()));
            builder.append(QueryTokens.expression(ctx.OTHERS()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionQuantifier(HqlParser.CollectionQuantifierContext ctx) {
        if (ctx.elementsValuesQuantifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.elementsValuesQuantifier());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.indicesKeysQuantifier());
    }

    @Override
    public QueryTokenStream visitElementsValuesQuantifier(HqlParser.ElementsValuesQuantifierContext ctx) {
        return QueryRenderer.from(QueryTokens.token(ctx.ELEMENTS() != null ? ctx.ELEMENTS() : ctx.VALUES()));
    }

    @Override
    public QueryTokenStream visitIndicesKeysQuantifier(HqlParser.IndicesKeysQuantifierContext ctx) {
        return QueryRenderer.from(QueryTokens.token(ctx.INDICES() != null ? ctx.INDICES() : ctx.KEYS()));
    }

    @Override
    public QueryTokenStream visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment());
    }

    @Override
    public QueryTokenStream visitPath(HqlParser.PathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.syntacticDomainPath() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.syntacticDomainPath()));
            if (ctx.pathContinuation() != null) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
            }
        } else if (ctx.generalPathFragment() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        if (ctx.indexedPathAccessFragment() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_SQUARE_BRACKET);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_SQUARE_BRACKET);
        if (ctx.generalPathFragment() != null) {
            builder.append(QueryTokens.TOKEN_DOT);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePath(HqlParser.SimplePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        if (!ctx.simplePathElement().isEmpty()) {
            builder.append(QueryTokens.TOKEN_DOT);
        }
        builder.append(QueryTokenStream.concat(ctx.simplePathElement(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimplePathElement(HqlParser.SimplePathElementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseList(HqlParser.CaseListContext ctx) {
        if (ctx.simpleCaseExpression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simpleCaseExpression());
        }
        if (ctx.searchedCaseExpression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.searchedCaseExpression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        ctx.caseWhenExpressionClause().forEach(caseWhenExpressionClauseContext -> builder.append((QueryTokenStream)this.visit((ParseTree)caseWhenExpressionClauseContext)));
        if (ctx.ELSE() != null) {
            builder.append(QueryTokens.expression(ctx.ELSE()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        }
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.append(QueryTokenStream.concat(ctx.caseWhenPredicateClause(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        if (ctx.ELSE() != null) {
            builder.append(QueryTokens.expression(ctx.ELSE()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        }
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseWhenExpressionClause(HqlParser.CaseWhenExpressionClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCaseWhenPredicateClause(HqlParser.CaseWhenPredicateClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionName()));
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.genericFunctionArguments() != null) {
            nested.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.genericFunctionArguments()));
        } else if (ctx.ASTERISK() != null) {
            nested.append(QueryTokens.token(ctx.ASTERISK()));
        }
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.append(nested);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        if (ctx.nthSideClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nthSideClause()));
        }
        if (ctx.nullsClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.nullsClause()));
        }
        if (ctx.withinGroupClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withinGroupClause()));
        }
        if (ctx.filterClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.overClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFilterClause(HqlParser.FilterClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FILTER()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.whereClause()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitOverClause(HqlParser.OverClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.OVER()));
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.append(QueryTokens.TOKEN_OPEN_PAREN);
        ArrayList<ParserRuleContext> trees = new ArrayList<ParserRuleContext>();
        if (ctx.partitionClause() != null) {
            trees.add(ctx.partitionClause());
        }
        if (ctx.orderByClause() != null) {
            trees.add(ctx.orderByClause());
        }
        if (ctx.frameClause() != null) {
            trees.add(ctx.frameClause());
        }
        nested.appendInline(QueryTokenStream.concat(trees, arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        nested.append(QueryTokens.TOKEN_CLOSE_PAREN);
        builder.appendInline(nested);
        return builder;
    }

    @Override
    public QueryTokenStream visitPartitionClause(HqlParser.PartitionClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.PARTITION()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.append(QueryTokenStream.concat(ctx.expression(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitFrameClause(HqlParser.FrameClauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.RANGE() != null) {
            builder.append(QueryTokens.expression(ctx.RANGE()));
        } else if (ctx.ROWS() != null) {
            builder.append(QueryTokens.expression(ctx.ROWS()));
        } else if (ctx.GROUPS() != null) {
            builder.append(QueryTokens.expression(ctx.GROUPS()));
        }
        if (ctx.BETWEEN() != null) {
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameStart()));
        if (ctx.AND() != null) {
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameEnd()));
        }
        if (ctx.frameExclusion() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.frameExclusion()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCastFunction(HqlParser.CastFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.castTarget()));
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitCastTarget(HqlParser.CastTargetContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.castTargetType()));
        if (ctx.INTEGER_LITERAL() != null && !ctx.INTEGER_LITERAL().isEmpty()) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            ArrayList tokens = new ArrayList();
            ctx.INTEGER_LITERAL().forEach(terminalNode -> {
                if (!tokens.isEmpty()) {
                    tokens.add(QueryTokens.TOKEN_COMMA);
                }
                tokens.add(QueryTokens.expression(terminalNode));
            });
            builder.append(tokens);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCastTargetType(HqlParser.CastTargetTypeContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.expression(ctx.fullTargetName));
    }

    @Override
    public QueryTokenStream visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.EXTRACT() != null) {
            builder.append(QueryTokens.token(ctx.EXTRACT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
            nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.extractField()));
            nested.append(QueryTokens.expression(ctx.FROM()));
            nested.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.appendInline(nested);
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.datetimeField() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetimeField()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitExtractField(HqlParser.ExtractFieldContext ctx) {
        if (ctx.datetimeField() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.datetimeField());
        }
        if (ctx.dayField() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.dayField());
        }
        if (ctx.weekField() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.weekField());
        }
        if (ctx.timeZoneField() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.timeZoneField());
        }
        if (ctx.dateOrTimeField() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.dateOrTimeField());
        }
        return QueryRenderer.builder();
    }

    @Override
    public QueryTokenStream visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TRIM()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.trimSpecification() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trimSpecification()));
        }
        if (ctx.trimCharacter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trimCharacter()));
        }
        if (ctx.FROM() != null) {
            builder.append(QueryTokens.expression(ctx.FROM()));
        }
        if (ctx.expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.BOTH() != null) {
            builder.append(QueryTokens.expression(ctx.BOTH()));
        } else if (ctx.LEADING() != null) {
            builder.append(QueryTokens.expression(ctx.LEADING()));
        } else if (ctx.TRAILING() != null) {
            builder.append(QueryTokens.expression(ctx.TRAILING()));
        }
        return builder.build();
    }

    @Override
    public QueryTokenStream visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        if (ctx.STRING_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.STRING_LITERAL()));
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
    }

    @Override
    public QueryTokenStream visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.everyAllQuantifier()));
        if (ctx.predicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            if (ctx.filterClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
            }
            if (ctx.overClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
            }
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.collectionQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.anySomeQuantifier()));
        if (ctx.predicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            if (ctx.filterClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.filterClause()));
            }
            if (ctx.overClause() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.overClause()));
            }
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.collectionQuantifier()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TREAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        QueryRenderer.QueryRendererBuilder nested = QueryRenderer.builder();
        nested.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        nested.append(QueryTokens.expression(ctx.AS()));
        nested.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitCollectionValueNavigablePath(HqlParser.CollectionValueNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.elementValueQuantifier()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.indexKeyQuantifier()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinuation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.pathContinuation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitToOneFkReference(HqlParser.ToOneFkReferenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FK()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitElementValueQuantifier(HqlParser.ElementValueQuantifierContext ctx) {
        if (ctx.ELEMENT() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.ELEMENT()));
        }
        if (ctx.VALUE() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.VALUE()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitIndexKeyQuantifier(HqlParser.IndexKeyQuantifierContext ctx) {
        if (ctx.INDEX() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INDEX()));
        }
        if (ctx.KEY() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.KEY()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitIsBooleanPredicate(HqlParser.IsBooleanPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.NULL() != null) {
            builder.append(QueryTokens.expression(ctx.NULL()));
        }
        if (ctx.TRUE() != null) {
            builder.append(QueryTokens.expression(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            builder.append(QueryTokens.expression(ctx.FALSE()));
        }
        if (ctx.EMPTY() != null) {
            builder.append(QueryTokens.expression(ctx.EMPTY()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.MEMBER() != null) {
            builder.append(QueryTokens.expression(ctx.MEMBER()));
        }
        if (ctx.OF() != null) {
            builder.append(QueryTokens.expression(ctx.OF()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.path()));
        return builder;
    }

    @Override
    public QueryTokenStream visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
            builder.append(QueryTokens.expression(ctx.FROM()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.betweenExpression());
    }

    @Override
    public QueryTokenStream visitContainsPredicate(HqlParser.ContainsPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.CONTAINS() != null) {
            builder.append(QueryTokens.expression(ctx.CONTAINS()));
        }
        if (ctx.INCLUDES() != null) {
            builder.append(QueryTokens.expression(ctx.INCLUDES()));
        }
        if (ctx.INTERSECTS() != null) {
            builder.append(QueryTokens.expression(ctx.INTERSECTS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(0)));
        builder.append(QueryTokens.expression(ctx.OR()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitRelationalPredicate(HqlParser.RelationalPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.relationalExpression());
    }

    @Override
    public QueryTokenStream visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.existsExpression());
    }

    @Override
    public QueryTokenStream visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(0)));
        builder.append(QueryTokens.expression(ctx.AND()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.predicate(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.stringPatternMatching());
    }

    @Override
    public QueryTokenStream visitInPredicate(HqlParser.InPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.inExpression());
    }

    @Override
    public QueryTokenStream visitNotPredicate(HqlParser.NotPredicateContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_NOT);
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.predicate()));
        return builder;
    }

    @Override
    public QueryTokenStream visitExpressionPredicate(HqlParser.ExpressionPredicateContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public QueryTokenStream visitExpressionOrPredicate(HqlParser.ExpressionOrPredicateContext ctx) {
        if (ctx.expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.expression());
        }
        if (ctx.predicate() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.predicate());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitRelationalExpression(HqlParser.RelationalExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitBetweenExpression(HqlParser.BetweenExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.BETWEEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        builder.append(QueryTokens.expression(ctx.AND()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(2)));
        return builder;
    }

    @Override
    public QueryTokenStream visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.LIKE() != null) {
            builder.append(QueryTokens.expression(ctx.LIKE()));
        } else if (ctx.ILIKE() != null) {
            builder.append(QueryTokens.expression(ctx.ILIKE()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression(1)));
        if (ctx.ESCAPE() != null) {
            builder.append(QueryTokens.expression(ctx.ESCAPE()));
            if (ctx.STRING_LITERAL() != null) {
                builder.append(QueryTokens.expression(ctx.STRING_LITERAL()));
            } else if (ctx.JAVA_STRING_LITERAL() != null) {
                builder.append(QueryTokens.expression(ctx.JAVA_STRING_LITERAL()));
            } else if (ctx.parameter() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInExpression(HqlParser.InExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.IN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.inList()));
        return builder;
    }

    @Override
    public QueryTokenStream visitInList(HqlParser.InListContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.expression(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.expression(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.parameter()));
        } else if (ctx.expressionOrPredicate() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.expressionOrPredicate(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitExistsExpression(HqlParser.ExistsExpressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.simplePath() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            if (ctx.ELEMENTS() != null) {
                builder.append(QueryTokens.expression(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                builder.append(QueryTokens.expression(ctx.INDICES()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.simplePath()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.expression() != null) {
            builder.append(QueryTokens.expression(ctx.EXISTS()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx) {
        if (ctx.LIST() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.LIST()));
        }
        if (ctx.MAP() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.MAP()));
        }
        if (ctx.simplePath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simplePath());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx) {
        return QueryTokenStream.concat(ctx.instantiationArgument(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA);
    }

    @Override
    public QueryTokenStream visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.expressionOrPredicate() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.expressionOrPredicate()));
        } else if (ctx.instantiation() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.instantiation()));
        }
        if (ctx.variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INTEGER_LITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.numericLiteral() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numericLiteral());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitVariable(HqlParser.VariableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.identifier() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.nakedIdentifier() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.nakedIdentifier()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitParameter(HqlParser.ParameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.prefix.getText().equals(":")) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.prefix.getText().equals("?")) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            if (ctx.INTEGER_LITERAL() != null) {
                builder.append(QueryTokens.expression(ctx.INTEGER_LITERAL()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityName(HqlParser.EntityNameContext ctx) {
        return QueryTokenStream.concat(ctx.identifier(), arg_0 -> ((HqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitIdentifier(HqlParser.IdentifierContext ctx) {
        if (ctx.nakedIdentifier() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.nakedIdentifier());
        }
        if (ctx.FULL() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.FULL()));
        }
        if (ctx.LEFT() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.LEFT()));
        }
        if (ctx.INNER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.INNER()));
        }
        if (ctx.OUTER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.OUTER()));
        }
        if (ctx.RIGHT() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.RIGHT()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNakedIdentifier(HqlParser.NakedIdentifierContext ctx) {
        if (ctx.IDENTIFIER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.IDENTIFIER()));
        }
        if (ctx.QUOTED_IDENTIFIER() != null) {
            return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.QUOTED_IDENTIFIER()));
        }
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.token(ctx.f));
    }
}

