/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

class JpaKeysetScrollQueryCreator
extends JpaQueryCreator {
    private final JpaEntityInformation<?, ?> entityInformation;
    private final KeysetScrollPosition scrollPosition;

    public JpaKeysetScrollQueryCreator(PartTree tree, ReturnedType type, CriteriaBuilder builder, ParameterMetadataProvider provider, JpaEntityInformation<?, ?> entityInformation, KeysetScrollPosition scrollPosition) {
        super(tree, type, builder, provider);
        this.entityInformation = entityInformation;
        this.scrollPosition = scrollPosition;
    }

    protected CriteriaQuery<?> complete(@Nullable Predicate predicate, Sort sort, CriteriaQuery<?> query, CriteriaBuilder builder, Root<?> root) {
        KeysetScrollSpecification keysetSpec = new KeysetScrollSpecification(this.scrollPosition, sort, this.entityInformation);
        Predicate keysetPredicate = keysetSpec.createPredicate(root, builder);
        CriteriaQuery<? extends Object> queryToUse = super.complete(predicate, keysetSpec.sort(), query, builder, root);
        if (keysetPredicate != null) {
            if (queryToUse.getRestriction() != null) {
                return queryToUse.where((Expression)builder.and((Expression)queryToUse.getRestriction(), (Expression)keysetPredicate));
            }
            return queryToUse.where((Expression)keysetPredicate);
        }
        return queryToUse;
    }

    @Override
    Collection<String> getRequiredSelection(Sort sort, ReturnedType returnedType) {
        Sort sortToUse = KeysetScrollSpecification.createSort(this.scrollPosition, sort, this.entityInformation);
        return KeysetScrollDelegate.getProjectionInputProperties(this.entityInformation, returnedType.getInputProperties(), sortToUse);
    }
}

