/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import java.util.List;
import org.springframework.data.domain.Limit;
import org.springframework.data.jpa.repository.query.EntityQuery;
import org.springframework.data.jpa.repository.query.ParameterBinding;

abstract class AotQuery {
    private final List<ParameterBinding> parameterBindings;

    AotQuery(List<ParameterBinding> parameterBindings) {
        this.parameterBindings = parameterBindings;
    }

    static boolean hasConstructorExpressionOrDefaultProjection(EntityQuery query) {
        return query.hasConstructorExpression() || query.isDefaultProjection();
    }

    public abstract boolean isNative();

    public List<ParameterBinding> getParameterBindings() {
        return this.parameterBindings;
    }

    public Limit getLimit() {
        return Limit.unlimited();
    }

    public boolean isLimited() {
        return this.getLimit().isLimited();
    }

    public boolean isDelete() {
        return false;
    }

    public boolean isExists() {
        return false;
    }

    public boolean hasExpression() {
        for (ParameterBinding parameterBinding : this.parameterBindings) {
            if (!parameterBinding.getOrigin().isExpression()) continue;
            return true;
        }
        return false;
    }

    public abstract boolean hasConstructorExpressionOrDefaultProjection();
}

