/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.Tuple;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.SearchResult;
import org.springframework.data.domain.SearchResults;
import org.springframework.data.domain.Similarity;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaResultConverters;
import org.springframework.data.jpa.repository.query.ScrollDelegate;
import org.springframework.data.jpa.repository.query.SimilarityNormalizer;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class JpaQueryExecution {
    private static final ConversionService CONVERSION_SERVICE;

    static {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((Converter)JpaResultConverters.BlobToByteArrayConverter.INSTANCE);
        conversionService.removeConvertible(Collection.class, Object.class);
        conversionService.removeConvertible(Object.class, Optional.class);
        CONVERSION_SERVICE = conversionService;
    }

    @Nullable
    public Object execute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
        Assert.notNull((Object)query, (String)"AbstractJpaQuery must not be null");
        Assert.notNull((Object)((Object)accessor), (String)"JpaParametersParameterAccessor must not be null");
        Object result = this.doExecute(query, accessor);
        if (result == null) {
            return null;
        }
        JpaQueryMethod queryMethod = query.getQueryMethod();
        Class<?> requiredType = queryMethod.getReturnType();
        if (ClassUtils.isAssignable(requiredType, Void.TYPE) || ClassUtils.isAssignableValue(requiredType, (Object)result)) {
            return result;
        }
        return CONVERSION_SERVICE.canConvert(result.getClass(), requiredType) ? CONVERSION_SERVICE.convert(result, requiredType) : result;
    }

    @Nullable
    protected abstract Object doExecute(AbstractJpaQuery var1, JpaParametersParameterAccessor var2);

    static class CollectionExecution
    extends JpaQueryExecution {
        CollectionExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            return query.createQuery(accessor).getResultList();
        }
    }

    static class DeleteExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public DeleteExecution(EntityManager em) {
            this.em = em;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery jpaQuery, JpaParametersParameterAccessor accessor) {
            Query query = jpaQuery.createQuery(accessor);
            List resultList = query.getResultList();
            for (Object o : resultList) {
                this.em.remove(o);
            }
            return jpaQuery.getQueryMethod().isCollectionQuery() ? resultList : Integer.valueOf(resultList.size());
        }
    }

    static class ExistsExecution
    extends JpaQueryExecution {
        ExistsExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            return !query.createQuery(accessor).getResultList().isEmpty();
        }
    }

    static class ModifyingExecution
    extends JpaQueryExecution {
        private final EntityManager em;
        private final boolean flush;
        private final boolean clear;
        private final JpaQueryMethod method;

        public ModifyingExecution(JpaQueryMethod method, EntityManager em) {
            this.method = method;
            Assert.notNull((Object)em, (String)"The EntityManager must not be null");
            Class<?> returnType = method.getReturnType();
            boolean isVoid = ClassUtils.isAssignable(returnType, Void.class);
            boolean isInt = ClassUtils.isAssignable(returnType, Integer.class);
            boolean isLong = ClassUtils.isAssignable(returnType, Long.class);
            Assert.isTrue((isInt || isLong || isVoid ? 1 : 0) != 0, (String)("Modifying queries can only use void or int/Integer as return type; Offending method: " + String.valueOf((Object)method)));
            this.em = em;
            this.flush = method.getFlushAutomatically();
            this.clear = method.getClearAutomatically();
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            if (this.flush) {
                this.em.flush();
            }
            int result = query.createQuery(accessor).executeUpdate();
            if (this.clear) {
                this.em.clear();
            }
            if (ClassUtils.isAssignable(this.method.getReturnType(), Long.class)) {
                return (long)result;
            }
            return result;
        }
    }

    static class PagedExecution
    extends JpaQueryExecution {
        private final PersistenceProvider provider;

        PagedExecution(PersistenceProvider provider) {
            this.provider = provider;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor accessor) {
            Query query = repositoryQuery.createQuery(accessor);
            return PageableExecutionUtils.getPage((List)query.getResultList(), (Pageable)accessor.getPageable(), () -> this.count(query, repositoryQuery, accessor));
        }

        private long count(Query resultQuery, AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor accessor) {
            if (repositoryQuery.hasDeclaredCountQuery()) {
                return this.doCount(repositoryQuery, accessor);
            }
            return this.provider.getResultCount(resultQuery, () -> this.doCount(repositoryQuery, accessor));
        }

        long doCount(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor accessor) {
            List totals = repositoryQuery.createCountQuery(accessor).getResultList();
            if (totals.size() == 1) {
                Object result = totals.get(0);
                if (result instanceof Number) {
                    Number n = (Number)result;
                    return n.longValue();
                }
                return (Long)CONVERSION_SERVICE.convert(result, Long.class);
            }
            return totals.size();
        }
    }

    static class ProcedureExecution
    extends JpaQueryExecution {
        private final boolean collectionQuery;
        private static final String NO_SURROUNDING_TRANSACTION = "You're trying to execute a @Procedure method without a surrounding transaction that keeps the connection open so that the ResultSet can actually be consumed; Make sure the consumer code uses @Transactional or any other way of declaring a (read-only) transaction";

        ProcedureExecution(boolean collectionQuery) {
            this.collectionQuery = collectionQuery;
        }

        @Override
        @Nullable
        protected Object doExecute(AbstractJpaQuery jpaQuery, JpaParametersParameterAccessor accessor) {
            StoredProcedureQuery procedure;
            StoredProcedureJpaQuery query;
            block13: {
                Object object;
                Assert.isInstanceOf(StoredProcedureJpaQuery.class, (Object)jpaQuery);
                query = (StoredProcedureJpaQuery)jpaQuery;
                procedure = query.createQuery(accessor);
                Class<?> returnType = query.getQueryMethod().getReturnType();
                try {
                    boolean returnsResultSet = procedure.execute();
                    if (!returnsResultSet) break block13;
                    if (!SurroundingTransactionDetectorMethodInterceptor.INSTANCE.isSurroundingTransactionActive()) {
                        throw new InvalidDataAccessApiUsageException(NO_SURROUNDING_TRANSACTION);
                    }
                    if (Map.class.isAssignableFrom(returnType)) break block13;
                    Object object2 = object = this.collectionQuery ? procedure.getResultList() : procedure.getSingleResult();
                }
                catch (Throwable throwable) {
                    if (procedure instanceof AutoCloseable) {
                        AutoCloseable ac = (AutoCloseable)procedure;
                        try {
                            ac.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (procedure instanceof AutoCloseable) {
                    AutoCloseable ac = (AutoCloseable)procedure;
                    try {
                        ac.close();
                    }
                    catch (Exception exception) {}
                }
                return object;
            }
            Object object = query.extractOutputValue(procedure);
            if (procedure instanceof AutoCloseable) {
                AutoCloseable ac = (AutoCloseable)procedure;
                try {
                    ac.close();
                }
                catch (Exception exception) {}
            }
            return object;
        }
    }

    static class ScrollExecution
    extends JpaQueryExecution {
        private final Sort sort;
        private final ScrollDelegate<?> delegate;

        ScrollExecution(Sort sort, ScrollDelegate<?> delegate) {
            this.sort = sort;
            this.delegate = delegate;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            ScrollPosition scrollPosition = accessor.getScrollPosition();
            Query scrollQuery = query.createQuery(accessor);
            return this.delegate.scroll(scrollQuery, this.sort.and(accessor.getSort()), scrollPosition);
        }
    }

    static class SearchResultExecution
    extends JpaQueryExecution {
        private final JpaQueryExecution delegate;
        private final ReturnedType returnedType;
        private final ScoringFunction function;
        private final boolean normalizeSimilarity;
        private final SimilarityNormalizer normalizer;

        SearchResultExecution(JpaQueryExecution delegate, ReturnedType returnedType, ScoringFunction function, boolean normalizeSimilarity) {
            this.delegate = delegate;
            this.returnedType = returnedType;
            this.function = function;
            this.normalizeSimilarity = normalizeSimilarity;
            this.normalizer = normalizeSimilarity ? SimilarityNormalizer.get(function) : SimilarityNormalizer.IDENTITY;
        }

        @Override
        @Nullable
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            Object result = this.delegate.execute(query, accessor);
            if (result instanceof Tuple || result instanceof Object[]) {
                return this.map(result);
            }
            if (result instanceof Collection) {
                Collection c = (Collection)result;
                ArrayList<SearchResult> objects = new ArrayList<SearchResult>(c.size());
                for (Object o : c) {
                    objects.add(o instanceof Tuple || o instanceof Object[] ? this.map(o) : new SearchResult(o, 0.0));
                }
                return new SearchResults(objects);
            }
            return result;
        }

        @Nullable
        private SearchResult<Object> map(Object result) {
            if (result instanceof Tuple) {
                Tuple t = (Tuple)result;
                Tuple value = this.returnedType.needsCustomConstruction() ? t : t.get(0);
                try {
                    return new SearchResult((Object)value, this.getScore(((Number)t.get("distance", Number.class)).doubleValue()));
                }
                catch (RuntimeException runtimeException) {
                    return new SearchResult((Object)value, this.getScore(0.0));
                }
            }
            if (result instanceof Object[]) {
                Object[] objects = (Object[])result;
                Object[] value = this.returnedType.needsCustomConstruction() ? objects : objects[0];
                try {
                    return new SearchResult((Object)value, this.getScore(((Number)objects[objects.length - 1]).doubleValue()));
                }
                catch (RuntimeException runtimeException) {
                    return new SearchResult((Object)value, this.getScore(0.0));
                }
            }
            return null;
        }

        private Score getScore(double score) {
            return this.normalizeSimilarity ? Similarity.raw((double)this.normalizer.getSimilarity(score), (ScoringFunction)this.function) : Score.of((double)score, (ScoringFunction)this.function);
        }
    }

    static class SingleEntityExecution
    extends JpaQueryExecution {
        SingleEntityExecution() {
        }

        @Override
        @Nullable
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            return query.createQuery(accessor).getSingleResultOrNull();
        }
    }

    static class SlicedExecution
    extends JpaQueryExecution {
        SlicedExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            Pageable pageable = accessor.getPageable();
            Query createQuery = query.createQuery(accessor);
            int pageSize = 0;
            if (pageable.isPaged()) {
                pageSize = pageable.getPageSize();
                createQuery.setMaxResults(pageSize + 1);
            }
            List resultList = createQuery.getResultList();
            boolean hasNext = pageable.isPaged() && resultList.size() > pageSize;
            return new SliceImpl(hasNext ? resultList.subList(0, pageSize) : resultList, pageable, hasNext);
        }
    }

    static class StreamExecution
    extends JpaQueryExecution {
        private static final String NO_SURROUNDING_TRANSACTION = "You're trying to execute a streaming query method without a surrounding transaction that keeps the connection open so that the Stream can actually be consumed; Make sure the code consuming the stream uses @Transactional or any other way of declaring a (read-only) transaction";
        @Nullable
        private static final Method streamMethod = ReflectionUtils.findMethod(Query.class, (String)"getResultStream");

        StreamExecution() {
        }

        @Override
        @Nullable
        protected Object doExecute(AbstractJpaQuery query, JpaParametersParameterAccessor accessor) {
            if (!SurroundingTransactionDetectorMethodInterceptor.INSTANCE.isSurroundingTransactionActive()) {
                throw new InvalidDataAccessApiUsageException(NO_SURROUNDING_TRANSACTION);
            }
            Query jpaQuery = query.createQuery(accessor);
            if (streamMethod != null) {
                return ReflectionUtils.invokeMethod((Method)streamMethod, (Object)jpaQuery);
            }
            PersistenceProvider persistenceProvider = PersistenceProvider.fromEntityManager(query.getEntityManager());
            CloseableIterator<Object> iter = persistenceProvider.executeQueryWithResultStream(jpaQuery);
            return StreamUtils.createStreamFromIterator(iter);
        }
    }
}

