/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFragmentsContributor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.util.Assert;

public class JpaRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private EntityManager entityManager;
    private EntityPathResolver entityPathResolver = SimpleEntityPathResolver.INSTANCE;
    private JpaRepositoryFragmentsContributor repositoryFragmentsContributor = JpaRepositoryFragmentsContributor.DEFAULT;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    @Nullable
    private JpaQueryMethodFactory queryMethodFactory;
    @Nullable
    private @Nullable Function<@Nullable BeanFactory, QueryEnhancerSelector> queryEnhancerSelectorSource;

    public JpaRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }

    @Autowired
    public void setEntityPathResolver(ObjectProvider<EntityPathResolver> resolver) {
        this.entityPathResolver = (EntityPathResolver)resolver.getIfAvailable(() -> SimpleEntityPathResolver.INSTANCE);
    }

    public JpaRepositoryFragmentsContributor getRepositoryFragmentsContributor() {
        return this.repositoryFragmentsContributor;
    }

    public void setRepositoryFragmentsContributor(JpaRepositoryFragmentsContributor repositoryFragmentsContributor) {
        this.repositoryFragmentsContributor = repositoryFragmentsContributor;
    }

    public void setEscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = EscapeCharacter.of(escapeCharacter);
    }

    public void setQueryEnhancerSelectorSource(QueryEnhancerSelector queryEnhancerSelectorSource) {
        this.queryEnhancerSelectorSource = bf -> queryEnhancerSelectorSource;
    }

    public void setQueryEnhancerSelector(Class<? extends QueryEnhancerSelector> queryEnhancerSelectorType) {
        this.queryEnhancerSelectorSource = bf -> {
            if (bf != null) {
                ObjectProvider beanProvider = bf.getBeanProvider(queryEnhancerSelectorType);
                QueryEnhancerSelector selector = (QueryEnhancerSelector)beanProvider.getIfAvailable();
                if (selector != null) {
                    return selector;
                }
                if (bf instanceof AutowireCapableBeanFactory) {
                    AutowireCapableBeanFactory acbf = (AutowireCapableBeanFactory)bf;
                    return (QueryEnhancerSelector)acbf.createBean(queryEnhancerSelectorType);
                }
            }
            return (QueryEnhancerSelector)BeanUtils.instantiateClass((Class)queryEnhancerSelectorType);
        };
    }

    @Autowired
    public void setQueryMethodFactory(ObjectProvider<JpaQueryMethodFactory> resolver) {
        JpaQueryMethodFactory factory = (JpaQueryMethodFactory)resolver.getIfAvailable();
        if (factory != null) {
            this.queryMethodFactory = factory;
        }
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"EntityManager must not be null");
        return this.createRepositoryFactory(this.entityManager);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        JpaRepositoryFactory factory = new JpaRepositoryFactory(entityManager);
        factory.setEntityPathResolver(this.entityPathResolver);
        factory.setEscapeCharacter(this.escapeCharacter);
        factory.setFragmentsContributor(this.getRepositoryFragmentsContributor());
        if (this.queryMethodFactory != null) {
            factory.setQueryMethodFactory(this.queryMethodFactory);
        }
        if (this.queryEnhancerSelectorSource != null) {
            factory.setQueryEnhancerSelector(this.queryEnhancerSelectorSource.apply(this.beanFactory));
        }
        return factory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"EntityManager must not be null");
        super.afterPropertiesSet();
    }
}

