/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.function.Function;

public class JpqlQueryTemplates {
    public static final JpqlQueryTemplates UPPER = new JpqlQueryTemplates("UPPER", String::toUpperCase);
    public static final JpqlQueryTemplates LOWER = new JpqlQueryTemplates("LOWER", String::toLowerCase);
    private final String ignoreCaseOperator;
    private final Function<String, String> ignoreCaseFunction;

    JpqlQueryTemplates(String ignoreCaseOperator, Function<String, String> ignoreCaseFunction) {
        this.ignoreCaseOperator = ignoreCaseOperator;
        this.ignoreCaseFunction = ignoreCaseFunction;
    }

    public static JpqlQueryTemplates of(String ignoreCaseOperator, Function<String, String> ignoreCaseFunction) {
        return new JpqlQueryTemplates(ignoreCaseOperator, ignoreCaseFunction);
    }

    public String ignoreCase(String value) {
        return this.ignoreCaseFunction.apply(value);
    }

    public String getIgnoreCaseOperator() {
        return this.ignoreCaseOperator;
    }
}

