/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.data.jpa.repository.aot.AotMetamodel;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.util.Lazy;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.util.ObjectUtils;

public class AotEntityManagerFactoryCreator {
    private final Supplier<EntityManagerFactory> factory;
    private final Object key;

    private AotEntityManagerFactoryCreator(Supplier<EntityManagerFactory> factory, Object key) {
        this.factory = Lazy.of(factory);
        this.key = key;
    }

    public static AotEntityManagerFactoryCreator from(AotRepositoryContext repositoryContext) {
        List<String> typeNames = repositoryContext.getResolvedTypes().stream().filter(AotEntityManagerFactoryCreator::isJakartaAnnotated).map(Class::getName).toList();
        return AotEntityManagerFactoryCreator.from(PersistenceManagedTypes.of(typeNames, List.of()), typeNames);
    }

    public static AotEntityManagerFactoryCreator from(PersistenceUnitInfo persistenceUnitInfo) {
        return AotEntityManagerFactoryCreator.from(() -> new AotMetamodel(persistenceUnitInfo), (Object)persistenceUnitInfo);
    }

    public static AotEntityManagerFactoryCreator from(PersistenceManagedTypes managedTypes) {
        return AotEntityManagerFactoryCreator.from(managedTypes, (Object)managedTypes);
    }

    private static AotEntityManagerFactoryCreator from(PersistenceManagedTypes managedTypes, Object cacheKey) {
        return AotEntityManagerFactoryCreator.from(() -> new AotMetamodel(managedTypes), cacheKey);
    }

    public static AotEntityManagerFactoryCreator just(EntityManagerFactory entityManagerFactory) {
        return new AotEntityManagerFactoryCreator(() -> entityManagerFactory, entityManagerFactory.getMetamodel());
    }

    private static AotEntityManagerFactoryCreator from(Supplier<? extends AotMetamodel> metamodel, Object key) {
        return new AotEntityManagerFactoryCreator(() -> ((AotMetamodel)metamodel.get()).getEntityManagerFactory(), key);
    }

    private static boolean isJakartaAnnotated(Class<?> cls) {
        return cls.isAnnotationPresent(Entity.class) || cls.isAnnotationPresent(Embeddable.class) || cls.isAnnotationPresent(MappedSuperclass.class) || cls.isAnnotationPresent(Converter.class);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory.get();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void that;
        if (!(o instanceof AotEntityManagerFactoryCreator)) {
            return false;
        }
        AotEntityManagerFactoryCreator aotEntityManagerFactoryCreator = (AotEntityManagerFactoryCreator)o;
        return ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.key);
    }

    public String toString() {
        return "AotEntityManagerFactory{" + String.valueOf(this.key) + "}";
    }
}

