/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Collection;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SpelQueryEngine;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.lang.Nullable;

public abstract class AbstractKeyValueAdapter
implements KeyValueAdapter {
    private final QueryEngine<? extends KeyValueAdapter, ?, ?> engine;

    protected AbstractKeyValueAdapter() {
        this(null);
    }

    protected AbstractKeyValueAdapter(@Nullable QueryEngine<? extends KeyValueAdapter, ?, ?> engine) {
        this.engine = engine != null ? engine : new SpelQueryEngine();
        this.engine.registerAdapter(this);
    }

    protected QueryEngine<? extends KeyValueAdapter, ?, ?> getQueryEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        return type.cast(this.get(id, keyspace));
    }

    @Override
    @Nullable
    public <T> T delete(Object id, String keyspace, Class<T> type) {
        return type.cast(this.delete(id, keyspace));
    }

    @Override
    public <T> Iterable<T> find(KeyValueQuery<?> query, String keyspace, Class<T> type) {
        return this.engine.execute(query, keyspace, type);
    }

    public Collection<?> find(KeyValueQuery<?> query, String keyspace) {
        return this.engine.execute(query, keyspace);
    }

    @Override
    public long count(KeyValueQuery<?> query, String keyspace) {
        return this.engine.count(query, keyspace);
    }
}

